/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.jboss.windup.web.services.model.AnalysisContext;
import org.jboss.windup.web.services.model.ExecutionState;
import org.jboss.windup.web.services.model.FilterApplication;
import org.jboss.windup.web.services.model.MigrationProject;
import org.jboss.windup.web.services.model.ReportFilter;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=WindupExecution.class)
public class WindupExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WINDUP_EXECUTION_ID = "windup_execution_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="execution_sequence")
    @SequenceGenerator(name="execution_sequence", sequenceName="windup_execution", initialValue=1, allocationSize=1)
    @Column(name="windup_execution_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @ManyToOne(optional=false)
    @JsonIgnore
    private MigrationProject project;
    @Column(name="time_queued")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar timeQueued;
    @Column(name="time_started")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar timeStarted;
    @Column(name="time_completed")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar timeCompleted;
    @Column(name="output_path")
    private String outputPath;
    @Column(name="total_work")
    private int totalWork;
    @Column(name="work_completed")
    private int workCompleted;
    @Column(name="current_task", length=1024)
    private String currentTask;
    @Column(name="last_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar lastModified;
    @Column(name="status")
    private ExecutionState state;
    @OneToMany(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    private Set<FilterApplication> filterApplications;
    @OneToOne
    private AnalysisContext analysisContext;
    @OneToOne(mappedBy="windupExecution", cascade={CascadeType.PERSIST, CascadeType.REMOVE})
    private ReportFilter reportFilter = new ReportFilter(this);
    private static final DateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public WindupExecution() {
    }

    public WindupExecution(AnalysisContext context) {
        this();
        this.analysisContext = context;
        this.project = context.getMigrationProject();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public MigrationProject getProject() {
        return this.project;
    }

    public void setProject(MigrationProject project) {
        this.project = project;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputDirectoryName() {
        if (this.getOutputPath() == null) {
            return null;
        }
        return Paths.get(this.getOutputPath(), new String[0]).getFileName().toString();
    }

    public void setOutputDirectoryName(String dirName) {
    }

    public String getApplicationListRelativePath() {
        String directoryName = this.getOutputDirectoryName();
        if (directoryName == null) {
            return null;
        }
        return directoryName + "/index.html";
    }

    public void setApplicationListRelativePath(String path) {
    }

    public String getRuleProvidersExecutionOverviewRelativePath() {
        String directoryName = this.getOutputDirectoryName();
        if (directoryName == null) {
            return null;
        }
        return directoryName + "/reports/windup_ruleproviders.html";
    }

    public void setRuleProvidersExecutionOverviewRelativePath(String path) {
    }

    public Calendar getTimeQueued() {
        return this.timeQueued;
    }

    public void setTimeQueued(Calendar timeQueued) {
        this.timeQueued = timeQueued;
    }

    public Calendar getTimeStarted() {
        return this.timeStarted;
    }

    public void setTimeStarted(Calendar timeStarted) {
        this.timeStarted = timeStarted;
    }

    public Calendar getTimeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCompleted(Calendar timeCompleted) {
        this.timeCompleted = timeCompleted;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public void setTotalWork(int totalWork) {
        this.totalWork = totalWork;
    }

    public int getWorkCompleted() {
        return this.workCompleted;
    }

    public void setWorkCompleted(int workCompleted) {
        this.workCompleted = workCompleted;
    }

    public String getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(String currentTask) {
        this.currentTask = currentTask;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Calendar lastUpdate) {
        this.lastModified = lastUpdate;
    }

    public ExecutionState getState() {
        return this.state;
    }

    public void setState(ExecutionState status) {
        this.state = status;
    }

    public void setAnalysisContext(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public void addFilterApplication(FilterApplication filterApplication) {
        this.filterApplications.add(filterApplication);
    }

    public Set<FilterApplication> getFilterApplications() {
        return this.filterApplications;
    }

    public void setFilterApplications(Set<FilterApplication> filterApplications) {
        this.filterApplications = filterApplications;
    }

    @JsonProperty
    public long getProjectId() {
        if (this.project == null) {
            return 0L;
        }
        return this.project.getId();
    }

    public ReportFilter getReportFilter() {
        return this.reportFilter;
    }

    public String toString() {
        return "WindupExecution{outputPath='" + this.outputPath + '\'' + ", totalWork=" + this.totalWork + ", workCompleted=" + this.workCompleted + ", currentTask='" + this.currentTask + '\'' + ", lastModified=" + this.formatCalendar(this.lastModified) + ", state=" + (Object)((Object)this.state) + ", version=" + this.version + ", timeCompleted=" + this.formatCalendar(this.timeCompleted) + ", timeStarted=" + this.formatCalendar(this.timeStarted) + '}';
    }

    private String formatCalendar(Calendar cal) {
        if (cal == null) {
            return "null";
        }
        FORMATTER.setTimeZone(cal.getTimeZone());
        return FORMATTER.format(cal.getTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindupExecution that = (WindupExecution)o;
        if (this.version != that.version) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.version;
        return result;
    }
}

