/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import javax.validation.Valid;
import org.hibernate.annotations.Type;
import org.jboss.windup.web.services.model.LabelsPath;
import org.jboss.windup.web.services.model.MigrationProject;
import org.jboss.windup.web.services.model.RulesPath;

@Entity
@NamedQueries(value={@NamedQuery(name="Configuration.findByRulePath", query="select c from Configuration c inner join c.rulesPaths r where r.id = :rulePathId"), @NamedQuery(name="Configuration.findByLabelPath", query="select c from Configuration c inner join c.labelsPaths r where r.id = :labelPathId"), @NamedQuery(name="Configuration.findGlobal", query="select configuration from Configuration configuration where configuration.global = true"), @NamedQuery(name="Configuration.findAll", query="select c from Configuration c")})
public class Configuration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_RULE_PATH_ID = "Configuration.findByRulePath";
    public static final String FIND_BY_LABEL_PATH_ID = "Configuration.findByLabelPath";
    public static final String FIND_GLOBAL = "Configuration.findGlobal";
    public static final String FIND_ALL = "Configuration.findAll";
    public static final String CONFIGURATION_ID = "configuration_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="configuration_id", updatable=false, nullable=false)
    private Long id;
    @Column
    @Type(type="yes_no")
    private boolean global;
    @Version
    @Column(name="version")
    private int version;
    @Valid
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<RulesPath> rulesPaths;
    @Valid
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<LabelsPath> labelsPaths;
    @OneToOne(mappedBy="configuration", fetch=FetchType.LAZY)
    private MigrationProject migrationProject;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Set<RulesPath> getRulesPaths() {
        return this.rulesPaths;
    }

    public void setRulesPaths(Set<RulesPath> rulesPaths) {
        this.rulesPaths = rulesPaths;
    }

    public Set<LabelsPath> getLabelsPaths() {
        return this.labelsPaths;
    }

    public void setLabelsPaths(Set<LabelsPath> labelsPaths) {
        this.labelsPaths = labelsPaths;
    }

    @JsonIgnore
    public MigrationProject getMigrationProject() {
        return this.migrationProject;
    }

    @JsonIgnore
    public void setMigrationProject(MigrationProject migrationProject) {
        this.migrationProject = migrationProject;
    }
}

