/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.jboss.windup.web.services.model.LabelEntity;
import org.jboss.windup.web.services.model.LabelsPath;

@Entity
@JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id", scope=LabelProviderEntity.class)
@NamedQueries(value={@NamedQuery(name="LabelProviderEntity.findAll", query="select lpe from LabelProviderEntity lpe"), @NamedQuery(name="LabelProviderEntity.deleteAll", query="delete from LabelProviderEntity"), @NamedQuery(name="LabelProviderEntity.deleteByLabelsPath", query="delete from LabelProviderEntity lpe where lpe.labelsPath = :labelsPath"), @NamedQuery(name="LabelProviderEntity.deleteNullPath", query="delete from LabelProviderEntity lpe where lpe.labelsPath is null")})
public class LabelProviderEntity
implements Serializable {
    public static final String FIND_ALL = "LabelProviderEntity.findAll";
    public static final String DELETE_ALL = "LabelProviderEntity.deleteAll";
    public static final String DELETE_BY_LABELS_PATH = "LabelProviderEntity.deleteByLabelsPath";
    public static final String DELETE_WITH_NULL_LABELS_PATH = "LabelProviderEntity.deleteNullPath";
    public static final String LABELS_PATH_PARAM = "labelsPath";
    public static final String LABEL_PROVIDER_ENTITY_ID = "labels_provider_entity_id";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="labels_provider_entity_id", updatable=false, nullable=false)
    private Long id;
    @Version
    @Column(name="version")
    private int version;
    @Column(name="provider_id")
    private String providerID;
    @Column(name="origin", length=2048)
    private String origin;
    @Column(name="description", length=8192)
    private String description;
    @Column(name="date_loaded")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dateLoaded;
    @Column(name="date_modified")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar dateModified;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderColumn(name="label_sequence")
    private List<LabelEntity> labels = new ArrayList<LabelEntity>();
    @ManyToOne(fetch=FetchType.EAGER)
    private LabelsPath labelsPath;
    @Lob
    private String loadError;
    @Column
    private LabelProviderType labelProviderType;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Calendar getDateLoaded() {
        return this.dateLoaded;
    }

    public void setDateLoaded(Calendar dateLoaded) {
        this.dateLoaded = dateLoaded;
    }

    public Calendar getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Calendar dateModified) {
        this.dateModified = dateModified;
    }

    public List<LabelEntity> getLabels() {
        return this.labels;
    }

    public void setLabels(List<LabelEntity> labels) {
        this.labels = labels;
    }

    public LabelsPath getLabelsPath() {
        return this.labelsPath;
    }

    public void setLabelsPath(LabelsPath labelsPath) {
        this.labelsPath = labelsPath;
    }

    public LabelProviderType getLabelProviderType() {
        return this.labelProviderType;
    }

    public void setLabelProviderType(LabelProviderType labelProviderType) {
        this.labelProviderType = labelProviderType;
    }

    public String getLoadError() {
        return this.loadError;
    }

    public void setLoadError(String loadError) {
        this.loadError = loadError;
    }

    public static enum LabelProviderType {
        XML;

    }
}

