/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@JsonIgnoreProperties(ignoreUnknown=true)
@Table(indexes={@Index(columnList="parent_package_id", unique=false)})
public class Package
implements Serializable {
    public static final String PACKAGE_ID = "package_id";
    public static final String PARENT_PACKAGE_ID = "parent_package_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="package_id", updatable=false, nullable=false)
    private Long id;
    @Column(length=256)
    @Size(min=0, max=256)
    @NotNull
    private @Size(min=0, max=256) @NotNull String name;
    @Column(length=256)
    @Size(min=0, max=256)
    @NotNull
    private @Size(min=0, max=256) @NotNull String fullName;
    @Column
    private int countClasses;
    @Type(type="yes_no")
    private boolean isKnown;
    @ManyToOne
    @JsonIgnore
    @JoinColumn(name="parent_package_id")
    private Package parent;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="parent")
    private Set<Package> childs;

    public Package() {
        this.childs = new HashSet<Package>();
    }

    public Package(String name) {
        this.name = name;
        this.childs = new HashSet<Package>();
    }

    public Package(String partialName, String fullName, boolean isKnown) {
        this.name = partialName;
        this.fullName = fullName;
        this.childs = new HashSet<Package>();
        this.isKnown = isKnown;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public int getCountClasses() {
        return this.countClasses;
    }

    public void setCountClasses(int countClasses) {
        this.countClasses = countClasses;
    }

    public Package getParent() {
        return this.parent;
    }

    public void setParent(Package parent) {
        this.parent = parent;
    }

    public Collection<Package> getChilds() {
        return this.childs;
    }

    public void addChild(Package child) {
        this.childs.add(child);
    }

    public void removeChild(Package child) {
        this.childs.remove(child);
    }

    public boolean isKnown() {
        return this.isKnown;
    }

    public void setKnown(boolean known) {
        this.isKnown = known;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }
}

