/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.web.services.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.jboss.windup.web.services.model.Package;

@Entity
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class PackageMetadata
implements Serializable {
    public static final String PACKAGE_METADATA_ID = "package_metadata_id";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="package_metadata_id", updatable=false, nullable=false)
    private Long id;
    @Column
    private Date discoveredDate = new Date();
    @Column
    private ScanStatus scanStatus = ScanStatus.QUEUED;
    @ManyToMany(fetch=FetchType.EAGER)
    private Set<Package> packages = new HashSet<Package>();

    public Long getId() {
        return this.id;
    }

    public Date getDiscoveredDate() {
        return this.discoveredDate;
    }

    public void setDiscoveredDate(Date discoveredDate) {
        this.discoveredDate = discoveredDate;
    }

    public ScanStatus getScanStatus() {
        return this.scanStatus;
    }

    public void setScanStatus(ScanStatus scanStatus) {
        this.scanStatus = scanStatus;
    }

    @JsonIgnore
    public Collection<Package> getPackages() {
        return this.packages;
    }

    @JsonIgnore
    public void setPackages(Collection<Package> packages) {
        this.packages = new HashSet<Package>(packages);
    }

    @JsonProperty(value="packageTree")
    public Collection<Package> getRootPackages() {
        return this.packages.stream().filter(item -> item.getLevel() == 0).collect(Collectors.toList());
    }

    public void addPackage(Package aPackage) {
        this.packages.add(aPackage);
    }

    public void removePackage(Package aPackage) {
        this.packages.remove(aPackage);
    }

    public static enum ScanStatus {
        QUEUED,
        IN_PROGRESS,
        COMPLETE;

    }
}

