/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.windup;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.windup.bootstrap.commands.AbstractListCommand;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;

public class ListTagsCommand
extends AbstractListCommand
implements Command,
FurnaceDependent {
    private final List<Path> userProvidedPaths;

    public ListTagsCommand(List<String> arguments) {
        this.userProvidedPaths = this.getUserProvidedPaths(arguments);
    }

    @Override
    public CommandResult execute() {
        Set result;
        if (this.userProvidedPaths.isEmpty()) {
            result = ListTagsCommand.getOptionValuesFromHelp("includeTags");
        } else {
            RuleProviderRegistryCache ruleProviderRegistryCache = (RuleProviderRegistryCache)this.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(RuleProviderRegistryCache.class).get();
            this.userProvidedPaths.forEach(userProvidedPath -> ruleProviderRegistryCache.addUserRulesPath(userProvidedPath));
            result = ruleProviderRegistryCache.getAvailableTags();
        }
        ListTagsCommand.printValuesSorted("Available tags", result);
        return CommandResult.EXIT;
    }

    @Override
    public CommandPhase getPhase() {
        return this.userProvidedPaths.isEmpty() ? CommandPhase.PRE_CONFIGURATION : CommandPhase.PRE_EXECUTION;
    }
}

