/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.builder;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.activation.NullActivator;
import org.jboss.aesh.cl.activation.OptionActivator;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.converter.CLConverterManager;
import org.jboss.aesh.cl.converter.Converter;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.renderer.NullOptionRenderer;
import org.jboss.aesh.cl.renderer.OptionRenderer;
import org.jboss.aesh.cl.validator.NullValidator;
import org.jboss.aesh.cl.validator.OptionValidator;

public class OptionBuilder {
    private char shortName;
    private String name;
    private String description;
    private String argument;
    private Class<?> type;
    private boolean hasValue = true;
    private boolean required = false;
    private boolean isProperty = false;
    private boolean hasMultipleValues = false;
    private char valueSeparator = (char)44;
    private OptionType optionType;
    private Converter converter;
    private String fieldName;
    private OptionCompleter completer;
    private final List<String> defaultValues = new ArrayList<String>();
    private OptionValidator validator;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired;

    public OptionBuilder shortName(char n) {
        this.shortName = n;
        return this;
    }

    public OptionBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OptionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder argument(String argument) {
        this.argument = argument;
        return this;
    }

    public OptionBuilder type(Class<?> type) {
        this.type = type;
        return this;
    }

    public OptionBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public OptionBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public OptionBuilder hasValue(boolean hasValue) {
        this.hasValue = hasValue;
        return this;
    }

    public OptionBuilder isProperty(boolean isProperty) {
        this.isProperty = isProperty;
        return this;
    }

    public OptionBuilder hasMultipleValues(boolean hasMultipleValues) {
        this.hasMultipleValues = hasMultipleValues;
        return this;
    }

    public OptionBuilder addDefaultValue(String defaultValue) {
        this.defaultValues.add(defaultValue);
        return this;
    }

    public OptionBuilder valueSeparator(char valueSeparator) {
        this.valueSeparator = valueSeparator;
        return this;
    }

    public OptionBuilder optionType(OptionType optionType) {
        this.optionType = optionType;
        return this;
    }

    public OptionBuilder converter(Converter converter) {
        this.converter = converter;
        return this;
    }

    public OptionBuilder completer(OptionCompleter completer) {
        this.completer = completer;
        return this;
    }

    public OptionBuilder validator(OptionValidator validator) {
        this.validator = validator;
        return this;
    }

    public OptionBuilder activator(OptionActivator activator) {
        this.activator = activator;
        return this;
    }

    public OptionBuilder renderer(OptionRenderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public OptionBuilder overrideRequired(boolean overrideRequired) {
        this.overrideRequired = overrideRequired;
        return this;
    }

    public ProcessedOption create() throws OptionParserException {
        if (this.optionType == null) {
            this.optionType = !this.hasValue ? OptionType.BOOLEAN : (this.isProperty ? OptionType.GROUP : (this.hasMultipleValues ? OptionType.LIST : OptionType.NORMAL));
        }
        if (this.name == null || this.name.length() < 1 && this.optionType != OptionType.ARGUMENT) {
            if (this.fieldName == null || this.fieldName.length() < 1) {
                throw new OptionParserException("Name must be defined to create an Option");
            }
            this.name = this.fieldName;
        }
        if (this.type == null) {
            throw new OptionParserException("Type must be defined to create an Option");
        }
        if (this.validator == null) {
            this.validator = new NullValidator();
        }
        if (this.converter == null) {
            this.converter = CLConverterManager.getInstance().getConverter(this.type);
        }
        if (this.activator == null) {
            this.activator = new NullActivator();
        }
        if (this.renderer == null) {
            this.renderer = new NullOptionRenderer();
        }
        return new ProcessedOption(this.shortName, this.name, this.description, this.argument, this.required, this.valueSeparator, this.defaultValues, this.type, this.fieldName, this.optionType, this.converter, this.completer, this.validator, this.activator, this.renderer, this.overrideRequired);
    }
}

