/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandPopulator;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;

public class AeshCommandPopulator
implements CommandPopulator<Object> {
    private final CommandLineParser commandLineParser;

    public AeshCommandPopulator(CommandLineParser commandLineParser) {
        this.commandLineParser = commandLineParser;
    }

    @Override
    public void populateObject(Object instance, CommandLine line, InvocationProviders invocationProviders, AeshContext aeshContext, boolean validate) throws CommandLineParserException, OptionValidatorException {
        if (line.hasParserError()) {
            throw line.getParserException();
        }
        for (ProcessedOption option : this.commandLineParser.getCommand().getOptions()) {
            if (line.hasOption(option.getName())) {
                line.getOption(option.getName()).injectValueIntoField(instance, invocationProviders, aeshContext, validate);
                continue;
            }
            if (option.getDefaultValues().size() > 0) {
                option.injectValueIntoField(instance, invocationProviders, aeshContext, validate);
                continue;
            }
            this.resetField(instance, option.getFieldName(), option.hasValue());
        }
        if (line.getArgument() != null && line.getArgument().getValues().size() > 0 || this.commandLineParser.getCommand().getArgument() != null && this.commandLineParser.getCommand().getArgument().getDefaultValues().size() > 0) {
            line.getArgument().injectValueIntoField(instance, invocationProviders, aeshContext, validate);
        } else if (line.getArgument() != null) {
            this.resetField(instance, line.getArgument().getFieldName(), true);
        }
    }

    private void resetField(Object instance, String fieldName, boolean hasValue) {
        try {
            Field field = instance.getClass().getDeclaredField(fieldName);
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if (field.getType().isPrimitive()) {
                if (Boolean.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, false);
                } else if (Integer.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Short.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Character.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Character.valueOf('\u0000'));
                } else if (Byte.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0);
                } else if (Long.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0L);
                } else if (Float.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, Float.valueOf(0.0f));
                } else if (Double.TYPE.isAssignableFrom(field.getType())) {
                    field.set(instance, 0.0);
                }
            } else if (!hasValue && field.getType().equals(Boolean.class)) {
                field.set(instance, Boolean.FALSE);
            } else {
                field.set(instance, null);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

