/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.manual.console;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.extensions.manual.ManPage;
import org.jboss.aesh.extensions.page.FileDisplayer;
import org.jboss.aesh.extensions.page.SimpleFileParser;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.util.ANSI;

public class Man
extends FileDisplayer {
    private List<ManPage> manPages = new ArrayList<ManPage>();
    private SimpleFileParser loader;

    public Man(Console console) {
        this.setConsole(console);
        this.manPages = new ArrayList<ManPage>();
        this.loader = new SimpleFileParser();
    }

    public void setFile(String name) throws IOException {
        this.loader.setFile(name);
    }

    public void setFile(URL url) throws IOException {
    }

    public void setFile(InputStream input) throws IOException {
        this.loader.setFile(input);
    }

    public void complete(CompleteOperation completeOperation) {
        if (completeOperation.getBuffer().equals("m")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("ma")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("man")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("man ")) {
            for (ManPage page : this.manPages) {
                completeOperation.getCompletionCandidates().add(new TerminalString("man " + page.getCommand()));
            }
        }
    }

    @Override
    public FileParser getFileParser() {
        return this.loader;
    }

    @Override
    public void displayBottom() throws IOException {
        this.writeToConsole(ANSI.getInvertedBackground());
        this.writeToConsole("Manual page " + this.loader.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + ANSI.defaultText());
    }
}

