/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.parser.java.utils.Packages;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.JavaSource;

@Dependent
@FacetConstraint(value={MavenFacet.class})
public class MavenJavaSourceFacet
extends AbstractFacet<Project>
implements JavaSourceFacet {
    public List<DirectoryResource> getSourceDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getSourceDirectory());
        result.add(this.getTestSourceDirectory());
        return result;
    }

    public String calculateName(JavaResource resource) {
        String fullPath = Packages.fromFileSyntax((String)resource.getFullyQualifiedName());
        String pkg = this.calculatePackage(resource);
        String name = fullPath.substring(fullPath.lastIndexOf(pkg) + pkg.length() + 1);
        name = name.substring(0, name.lastIndexOf(".java"));
        return name;
    }

    public String calculatePackage(JavaResource resource) {
        List<DirectoryResource> folders = this.getSourceDirectories();
        String pkg = null;
        for (DirectoryResource folder : folders) {
            String sourcePrefix = folder.getFullyQualifiedName();
            pkg = resource.getParent().getFullyQualifiedName();
            if (!pkg.startsWith(sourcePrefix)) continue;
            pkg = pkg.substring(sourcePrefix.length() + 1);
            break;
        }
        pkg = Packages.fromFileSyntax(pkg);
        return pkg;
    }

    public String getBasePackage() {
        Model model = ((MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class)).getModel();
        String groupId = model.getGroupId();
        if (groupId == null) {
            groupId = model.getParent().getGroupId();
        }
        return Packages.toValidPackageName((String)groupId);
    }

    public DirectoryResource getBasePackageDirectory() {
        return this.getSourceDirectory().getChildDirectory(Packages.toFileSyntax((String)this.getBasePackage()));
    }

    public DirectoryResource getSourceDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String srcFolderName = build != null && build.getSourceDirectory() != null ? mavenFacet.resolveProperties(build.getSourceDirectory()) : "src" + File.separator + "main" + File.separator + "java";
        DirectoryResource projectRoot = ((Project)this.getFaceted()).getRootDirectory();
        return projectRoot.getChildDirectory(srcFolderName);
    }

    public DirectoryResource getTestSourceDirectory() {
        MavenFacet mavenFacet = (MavenFacet)((Project)this.getFaceted()).getFacet(MavenFacet.class);
        Build build = mavenFacet.getModel().getBuild();
        String srcFolderName = build != null && build.getTestSourceDirectory() != null ? mavenFacet.resolveProperties(build.getTestSourceDirectory()) : "src" + File.separator + "test" + File.separator + "java";
        DirectoryResource projectRoot = ((Project)this.getFaceted()).getRootDirectory();
        return projectRoot.getChildDirectory(srcFolderName);
    }

    public boolean isInstalled() {
        return this.getSourceDirectory().exists();
    }

    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getSourceDirectories()) {
                folder.mkdirs();
            }
        }
        return this.isInstalled();
    }

    public JavaResource getJavaResource(JavaSource<?> javaClass) {
        String pkg = Strings.isNullOrEmpty((String)javaClass.getPackage()) ? "" : javaClass.getPackage() + ".";
        return this.getJavaResource(pkg + javaClass.getName());
    }

    public JavaResource getTestJavaResource(JavaSource<?> javaClass) {
        String pkg = Strings.isNullOrEmpty((String)javaClass.getPackage()) ? "" : javaClass.getPackage() + ".";
        return this.getTestJavaResource(pkg + javaClass.getName());
    }

    public JavaResource getJavaResource(String relativePath) {
        return this.getJavaResource(this.getSourceDirectory(), relativePath);
    }

    public JavaResource getTestJavaResource(String relativePath) {
        return this.getJavaResource(this.getTestSourceDirectory(), relativePath);
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        if (Strings.isNullOrEmpty((String)relativePath)) {
            throw new ResourceException("Empty relative path");
        }
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = Packages.toFileSyntax((String)path) + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public JavaResource saveJavaSource(JavaSource<?> source) {
        return this.getJavaResource(source.getQualifiedName()).setContents(source);
    }

    public JavaResource saveTestJavaSource(JavaSource<?> source) {
        return this.getTestJavaResource(source.getQualifiedName()).setContents(source);
    }

    public void visitJavaSources(JavaResourceVisitor visitor) {
        new ResourceVisit((Resource)this.getSourceDirectory()).perform((ResourceVisitor)visitor, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return type instanceof JavaResource;
            }
        });
    }

    public void visitJavaTestSources(JavaResourceVisitor visitor) {
        new ResourceVisit((Resource)this.getTestSourceDirectory()).perform((ResourceVisitor)visitor, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return type instanceof JavaResource;
            }
        });
    }
}

