/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ocpsoft.common.util.Strings;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilderRoot;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilder;
import org.ocpsoft.rewrite.config.ConfigurationRuleBuilderCustom;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleBuilder;
import org.ocpsoft.rewrite.config.RuleMetadata;
import org.ocpsoft.rewrite.context.Context;

public class ConfigurationBuilder
implements Configuration,
ConfigurationBuilderRoot {
    private final List<RuleBuilder> rules = new ArrayList<RuleBuilder>();

    ConfigurationBuilder() {
    }

    @Override
    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<RuleBuilder> getRuleBuilders() {
        return Collections.unmodifiableList(this.rules);
    }

    public static ConfigurationBuilder begin() {
        return new ConfigurationBuilder();
    }

    @Override
    public ConfigurationRuleBuilderCustom addRule() {
        RuleBuilder rule = RuleBuilder.define();
        this.setDefaultLocation(rule);
        this.rules.add(rule);
        return new ConfigurationRuleBuilder(this, rule);
    }

    ConfigurationRuleBuilderCustom addOtherwiseRule(RuleBuilder origin) {
        RuleBuilder rule = RuleBuilder.define();
        rule.contextMap = origin.contextMap;
        this.rules.add(rule);
        return new ConfigurationRuleBuilder(this, rule);
    }

    @Override
    public ConfigurationRuleBuilder addRule(Rule rule) {
        RuleBuilder wrapped = null;
        wrapped = rule instanceof RuleBuilder ? (RuleBuilder)rule : RuleBuilder.wrap(rule);
        this.rules.add(wrapped);
        this.setDefaultLocation(wrapped);
        return new ConfigurationRuleBuilder(this, wrapped);
    }

    private void setDefaultLocation(Rule rule) {
        if (rule instanceof Context) {
            Throwable throwable = new Throwable().fillInStackTrace();
            StackTraceElement[] trace = throwable.getStackTrace();
            StackTraceElement location = null;
            for (StackTraceElement element : trace) {
                if (element.getClassName().startsWith("org.ocpsoft.rewrite.config")) continue;
                location = element;
                break;
            }
            if (location != null && ((Context)((Object)rule)).get(RuleMetadata.PROVIDER_LOCATION) == null) {
                ((Context)((Object)rule)).put(RuleMetadata.PROVIDER_LOCATION, location.toString());
            }
        }
    }

    public String toString() {
        return "ConfigurationBuilder.begin()\n" + Strings.join(this.rules, (String)"\n");
    }
}

