/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Predicate;
import java.nio.file.Paths;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;

public class FileModelService
extends GraphService<FileModel> {
    public FileModelService(GraphContext context) {
        super(context, FileModel.class);
    }

    public FileModel createByFilePath(String filePath) {
        return this.createByFilePath(null, filePath);
    }

    public FileModel createByFilePath(FileModel parentFile, String filePath) {
        String absolutePath = Paths.get(filePath, new String[0]).toAbsolutePath().toString();
        FileModel entry = this.findByPath(absolutePath);
        if (entry == null) {
            entry = (FileModel)this.create();
            entry.setFilePath(absolutePath);
            entry.setParentFile(parentFile);
        }
        return entry;
    }

    public FileModel findByPath(String filePath) {
        filePath = Paths.get(filePath, new String[0]).toAbsolutePath().toString();
        return (FileModel)this.getUniqueByProperty("filePath", filePath);
    }

    public Iterable<FileModel> findArchiveEntryWithExtension(String ... values) {
        String regex;
        if (values.length == 0) {
            return IterablesUtil.emptyIterable();
        }
        if (values.length == 1) {
            regex = ".+\\." + values[0] + "$";
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            for (String value : values) {
                builder.append("|");
                builder.append(value);
            }
            builder.append(")\\b");
            regex = ".+\\." + builder.toString() + "$";
        }
        return this.getGraphContext().getQuery().type(FileModel.class).has("filePath", (Predicate)Text.REGEX, (Object)regex).vertices(FileModel.class);
    }
}

