/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.service;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.windup.graph.FramedElementInMemory;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.InMemoryVertexFrame;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.Service;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;

public class GraphService<T extends WindupVertexFrame>
implements Service<T> {
    private Class<T> type;
    private GraphContext context;

    public GraphService(GraphContext context, Class<T> type) {
        this.context = context;
        this.type = type;
    }

    @Override
    public void commit() {
        ((TitanGraph)this.context.getGraph().getBaseGraph()).commit();
    }

    @Override
    public long count(Iterable<?> obj) {
        GremlinPipeline pipe = new GremlinPipeline();
        return pipe.start(obj).count();
    }

    @Override
    public T createInMemory() {
        Class[] resolvedTypes = new Class[]{VertexFrame.class, InMemoryVertexFrame.class, this.type};
        return (T)((WindupVertexFrame)Proxy.newProxyInstance(this.type.getClassLoader(), resolvedTypes, new FramedElementInMemory<T>(this.context, this.type)));
    }

    @Override
    public T create() {
        return (T)((WindupVertexFrame)this.context.getFramed().addVertex(null, this.type));
    }

    @Override
    public T create(Object id) {
        return (T)((WindupVertexFrame)this.context.getFramed().addVertex(id, this.type));
    }

    public void delete(T frame) {
        this.context.getFramed().removeVertex(frame.asVertex());
    }

    @Override
    public T addTypeToModel(WindupVertexFrame model) {
        return GraphService.addTypeToModel(this.getGraphContext(), model, this.type);
    }

    protected FramedGraphQuery findAllQuery() {
        return this.context.getQuery().type(this.type);
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAllQuery().vertices(this.type);
    }

    @Override
    public Iterable<T> findAllByProperties(String[] keys, String[] vals) {
        FramedGraphQuery fgq = this.findAllQuery();
        int j = keys.length;
        for (int i = 0; i < j; ++i) {
            String key = keys[i];
            String val = vals[i];
            fgq = fgq.has(key, (Object)val);
        }
        return fgq.vertices(this.type);
    }

    @Override
    public Iterable<T> findAllByProperty(String key, Object value) {
        return this.context.getFramed().getVertices(key, value, this.type);
    }

    @Override
    public Iterable<T> findAllByPropertyMatchingRegex(String key, String ... regex) {
        String regexFinal;
        if (regex.length == 0) {
            return IterablesUtil.emptyIterable();
        }
        if (regex.length == 1) {
            regexFinal = regex[0];
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("\\b(");
            int i = 0;
            for (String value : regex) {
                if (i > 0) {
                    builder.append("|");
                }
                builder.append(value);
                ++i;
            }
            builder.append(")\\b");
            regexFinal = builder.toString();
        }
        return this.findAllQuery().has(key, (Predicate)Text.REGEX, (Object)regexFinal).vertices(this.type);
    }

    @Override
    public T getById(Object id) {
        return (T)((WindupVertexFrame)this.context.getFramed().getVertex(id, this.type));
    }

    protected T frame(Vertex vertex) {
        return (T)((WindupVertexFrame)this.getGraphContext().getFramed().frame(vertex, this.getType()));
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected GraphQuery getTypedQuery() {
        return this.getGraphContext().getQuery().type(this.type);
    }

    protected String getTypeValueForSearch() {
        TypeValue typeValue = this.type.getAnnotation(TypeValue.class);
        if (typeValue == null) {
            throw new IllegalArgumentException("Must contain annotation 'TypeValue'");
        }
        return typeValue.value();
    }

    @Override
    public T getUnique() throws NonUniqueResultException {
        Iterable<T> results = this.findAll();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator<T> iter = results.iterator();
        WindupVertexFrame result = (WindupVertexFrame)iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    @Override
    public T getUniqueByProperty(String property, Object value) throws NonUniqueResultException {
        Iterable<T> results = this.findAllByProperty(property, value);
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator<T> iter = results.iterator();
        WindupVertexFrame result = (WindupVertexFrame)iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return (T)result;
    }

    protected T getUnique(GraphQuery framedQuery) {
        Iterable results = framedQuery.vertices();
        if (!results.iterator().hasNext()) {
            return null;
        }
        Iterator iter = results.iterator();
        Vertex result = (Vertex)iter.next();
        if (iter.hasNext()) {
            throw new NonUniqueResultException("Expected unique value, but returned non-unique.");
        }
        return this.frame(result);
    }

    protected GraphContext getGraphContext() {
        return this.context;
    }

    @Override
    public TitanTransaction newTransaction() {
        return ((TitanGraph)this.context.getGraph().getBaseGraph()).newTransaction();
    }

    public static List<WindupVertexFrame> toVertexFrames(GraphContext graphContext, Iterable<Vertex> vertices) {
        ArrayList<WindupVertexFrame> results = new ArrayList<WindupVertexFrame>();
        for (Vertex v : vertices) {
            WindupVertexFrame frame = (WindupVertexFrame)graphContext.getFramed().frame(v, WindupVertexFrame.class);
            results.add(frame);
        }
        return results;
    }

    public static <T extends WindupVertexFrame> List<T> toVertexFrames(GraphContext graphContext, Iterable<Vertex> vertices, Class<T> frameType) {
        ArrayList<WindupVertexFrame> results = new ArrayList<WindupVertexFrame>();
        for (Vertex v : vertices) {
            WindupVertexFrame frame = (WindupVertexFrame)graphContext.getFramed().frame(v, WindupVertexFrame.class);
            if (frameType.isAssignableFrom(frame.getClass())) {
                results.add(frame);
                continue;
            }
            throw new IllegalStateException("Expected frame type [" + frameType.getName() + "] but was " + frame.getClass().getInterfaces() + ".");
        }
        return results;
    }

    public static <T extends WindupVertexFrame> T addTypeToModel(GraphContext graphContext, WindupVertexFrame frame, Class<T> type) {
        Vertex vertex = frame.asVertex();
        graphContext.getGraphTypeRegistry().addTypeToElement(type, (Element)vertex);
        return (T)((WindupVertexFrame)graphContext.getFramed().frame(vertex, type));
    }

    @Override
    public void remove(T model) {
        model.asVertex().remove();
    }
}

