/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.VariableResolvingASTVisitor;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnalyzeJavaFilesRuleProvider
extends WindupRuleProvider {
    public RulePhase getPhase() {
        return RulePhase.INITIAL_ANALYSIS;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind javaSourceAvailable = Query.find(JavaSourceFileModel.class);
        return ConfigurationBuilder.begin().addRule().when((Condition)javaSourceAvailable).perform((Operation)new ParseSourceOperation().and((Operation)IterationProgress.monitoring((String)"Analyzed Java File: ", (int)250)));
    }

    private final class ParseSourceOperation
    extends AbstractIterationOperation<JavaSourceFileModel> {
        private ParseSourceOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, JavaSourceFileModel payload) {
            WindupJavaConfigurationService windupJavaConfigurationService = new WindupJavaConfigurationService(event.getGraphContext());
            if (!windupJavaConfigurationService.shouldScanPackage(payload.getPackageName())) {
                return;
            }
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setBindingsRecovery(true);
            parser.setResolveBindings(true);
            File sourceFile = payload.asFile();
            try {
                parser.setSource(FileUtils.readFileToString((File)sourceFile).toCharArray());
            }
            catch (IOException e) {
                throw new WindupException("Failed to get source for file: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
            }
            parser.setKind(8);
            CompilationUnit cu = (CompilationUnit)parser.createAST(null);
            VariableResolvingASTVisitor visitor = new VariableResolvingASTVisitor(event.getGraphContext());
            visitor.init(cu, payload);
            cu.accept((ASTVisitor)visitor);
        }

        public String toString() {
            return "ParseJavaSource";
        }
    }
}

