/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverMavenProjectsRuleProvider;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverMavenHierarchyRuleProvider
extends WindupRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverMavenProjectsRuleProvider.class);

    public RulePhase getPhase() {
        return RulePhase.DISCOVERY;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverMavenProjectsRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext arg0) {
        AbstractIterationOperation<MavenProjectModel> setupParentModule = new AbstractIterationOperation<MavenProjectModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, MavenProjectModel payload) {
                DiscoverMavenHierarchyRuleProvider.this.setMavenParentProject(payload);
            }

            public String toString() {
                return "ConfigureProjectHierarchy";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.find(MavenProjectModel.class)).perform((Operation)setupParentModule);
    }

    private void setParentProject(ArchiveModel archiveModel, MavenProjectModel projectModel) {
        if (archiveModel == null) {
            return;
        }
        if (archiveModel.getProjectModel() != null) {
            String mavenGAV = projectModel.getGroupId() + ":" + projectModel.getArtifactId() + ":" + projectModel.getVersion();
            String archivePath = archiveModel.getFilePath();
            LOG.info("Setting parent project for: " + mavenGAV + " to: " + archivePath);
            projectModel.setParentProject(archiveModel.getProjectModel());
        } else {
            this.setParentProject(archiveModel.getParentArchive(), projectModel);
        }
    }

    private void setParentProject(FileModel fileModel, MavenProjectModel projectModel) {
        if (fileModel == null) {
            return;
        }
        if (fileModel.getProjectModel() != null) {
            projectModel.setParentProject(fileModel.getProjectModel());
        } else {
            this.setParentProject(fileModel.getParentArchive(), projectModel);
        }
    }

    private void setMavenParentProject(MavenProjectModel projectModel) {
        FileModel fileModel = projectModel.getRootFileModel();
        if (fileModel == null) {
            return;
        }
        if (fileModel instanceof ArchiveModel) {
            ArchiveModel archiveModel = (ArchiveModel)fileModel;
            this.setParentProject(archiveModel.getParentArchive(), projectModel);
        } else {
            FileModel parentFile = fileModel.getParentFile();
            this.setParentProject(parentFile, projectModel);
        }
    }
}

