/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.forge.addon.parser.java.resources.AbstractJavaMemberResource;
import org.jboss.forge.addon.parser.java.resources.EnumConstantResourceImpl;
import org.jboss.forge.addon.parser.java.resources.JavaFieldResourceImpl;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResourceImpl;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.resource.AbstractFileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFacet;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourceUtil;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.EnumConstant;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaEnum;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Member;
import org.jboss.forge.roaster.model.MemberHolder;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.source.JavaSource;

public class JavaResourceImpl
extends AbstractFileResource<JavaResource>
implements JavaResource {
    private JavaType<?> javaType;
    private byte[] lastDigest;

    public JavaResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public <T extends JavaType<?>> T getJavaType() throws FileNotFoundException {
        if (this.isStale()) {
            this.refresh();
        }
        return (T)this.javaType;
    }

    public boolean isStale() {
        return this.javaType == null || super.isStale() || this.lastDigest != null && !Arrays.equals(this.lastDigest, ResourceUtil.getDigest((Resource)this));
    }

    public void refresh() {
        super.refresh();
        this.lastDigest = ResourceUtil.getDigest((Resource)this);
        this.javaType = Roaster.parse((InputStream)this.getResourceInputStream());
    }

    public Resource<?> getChild(String name) {
        List<Resource<?>> children = this.doListResources();
        ArrayList subset = new ArrayList();
        for (Resource<?> child : children) {
            if (name == null || !(child instanceof AbstractJavaMemberResource)) continue;
            String childName = child.getName();
            if (!((Member)child.getUnderlyingResourceObject()).getName().equals(name.trim()) && !childName.equals(name)) continue;
            subset.add(child);
        }
        if (subset.size() == 1) {
            return (Resource)subset.get(0);
        }
        if (subset.size() > 1) {
            throw new ResourceException("Ambiguous name [" + name + "], full type signature required");
        }
        return null;
    }

    protected synchronized List<Resource<?>> doListResources() {
        try {
            LinkedList list = new LinkedList();
            Object javaType = this.getJavaType();
            if (javaType instanceof MemberHolder) {
                MemberHolder memberHolder = (MemberHolder)javaType;
                for (Member member : memberHolder.getMembers()) {
                    if (member instanceof Field) {
                        list.add((Resource<?>)new JavaFieldResourceImpl(this.getResourceFactory(), (Resource<?>)this, (Field<?>)((Field)member)));
                        continue;
                    }
                    if (member instanceof Method) {
                        list.add((Resource<?>)new JavaMethodResourceImpl(this.getResourceFactory(), (Resource<?>)this, (Method<?, ?>)((Method)member)));
                        continue;
                    }
                    throw new UnsupportedOperationException("Unknown member type: " + member);
                }
                if (memberHolder instanceof JavaEnum) {
                    List enumConstants = ((JavaEnum)memberHolder).getEnumConstants();
                    for (EnumConstant e : enumConstants) {
                        list.add((Resource<?>)new EnumConstantResourceImpl(this.getResourceFactory(), (Resource<?>)this, (EnumConstant<?>)e));
                    }
                }
            }
            return list;
        }
        catch (ParserException e) {
            return Collections.emptyList();
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public JavaResourceImpl setContents(JavaSource<?> source) {
        this.setContents(source.toString());
        return this;
    }

    public JavaResourceImpl createFrom(File file) {
        return new JavaResourceImpl(this.getResourceFactory(), file);
    }

    public String toString() {
        try {
            return this.getJavaType().getQualifiedName();
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("Error while fetching the qualified name", (Throwable)e);
        }
        catch (Exception e) {
            return this.getName();
        }
    }

    public boolean supports(ResourceFacet type) {
        return false;
    }
}

