/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.impl.request;

import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.manager.impl.request.ConfigurationScanListener;
import org.jboss.forge.furnace.manager.request.AddonActionRequest;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;

public abstract class AbstractAddonActionRequest
implements AddonActionRequest {
    protected final AddonInfo addonInfo;
    protected final Furnace furnace;
    protected final MutableAddonRepository repository;
    protected Logger log = Logger.getLogger(this.getClass().getName());

    protected AbstractAddonActionRequest(AddonInfo addonInfo, MutableAddonRepository addonRepository, Furnace furnace) {
        Assert.notNull((Object)addonInfo, (String)"AddonInfo must not be null.");
        Assert.notNull((Object)furnace, (String)"Addon Repository must not be null.");
        Assert.notNull((Object)furnace, (String)"Furnace must not be null.");
        this.addonInfo = addonInfo;
        this.furnace = furnace;
        this.repository = addonRepository;
    }

    public final AddonInfo getRequestedAddonInfo() {
        return this.addonInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void perform() {
        ConfigurationScanListener listener = new ConfigurationScanListener();
        ListenerRegistration reg = this.furnace.addContainerLifecycleListener((ContainerLifecycleListener)listener);
        try {
            this.execute();
            if (this.furnace.getStatus().isStopped()) return;
            while (this.furnace.getStatus().isStarting() || !listener.isConfigurationScanned()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            reg.removeListener();
        }
    }

    public abstract void execute();

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getRequestedAddonInfo() + "]";
    }
}

