/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.config.ClassificationBuilderOf;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.FileReferenceModel;
import org.jboss.windup.reporting.model.LinkModel;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class Classification
extends AbstractIterationOperation<FileModel> {
    private static final Logger log = Logger.getLogger(Classification.class.getName());
    private List<Link> links = new ArrayList<Link>();
    private String classificationText;
    private String description;
    private int effort;

    Classification(String variable) {
        super(variable);
    }

    Classification() {
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
        this.checkVariableName(event, context);
        WindupVertexFrame payload = this.resolveVariable(event, this.getVariableName());
        if (payload instanceof FileReferenceModel) {
            this.perform(event, context, ((FileReferenceModel)payload).getFile());
        } else {
            super.perform(event, context);
        }
    }

    public static ClassificationBuilderOf of(String variable) {
        return new ClassificationBuilderOf(variable);
    }

    public Classification withDescription(String description) {
        this.description = description;
        return this;
    }

    public Classification with(Link link) {
        this.links.add(link);
        return this;
    }

    public Classification withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    public static Classification as(String classification) {
        Assert.notNull((Object)classification, (String)"Classification text must not be null.");
        Classification classif = new Classification();
        classif.classificationText = classification;
        return classif;
    }

    public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
        GraphContext graphContext = event.getGraphContext();
        GraphService classificationService = new GraphService(graphContext, ClassificationModel.class);
        ClassificationModel classification = (ClassificationModel)classificationService.getUniqueByProperty("classification", (Object)this.classificationText);
        if (classification == null) {
            classification = (ClassificationModel)classificationService.create();
            classification.setEffort(this.effort);
            classification.setDescription(this.description);
            classification.setClassifiation(this.classificationText);
            classification.setRuleID(((Rule)context.get(Rule.class)).getId());
            GraphService linkService = new GraphService(graphContext, LinkModel.class);
            for (Link link : this.links) {
                LinkModel linkModel = (LinkModel)linkService.create();
                linkModel.setDescription(link.getDescription());
                linkModel.setLink(link.getLink());
                classification.addLink(linkModel);
            }
        }
        for (FileModel existingFileModel : classification.getFileModels()) {
            if (!existingFileModel.asVertex().getId().equals(payload.asVertex().getId())) continue;
            log.info("Classification already added to " + payload.getPrettyPathWithinProject() + " [" + (Object)((Object)this) + "] -- not adding again");
            return;
        }
        classification.addFileModel(payload);
        log.info("Classification added to " + payload.getPrettyPathWithinProject() + " [" + (Object)((Object)this) + "] ");
    }

    protected void setClassificationText(String classification) {
        this.classificationText = classification;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Classification.as(" + this.classificationText + ")");
        if (this.description != null && !this.description.trim().isEmpty()) {
            result.append(".withDescription(" + this.description + ")");
        }
        if (this.effort != 0) {
            result.append(".withEffort(" + this.effort + ")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(" + this.links + ")");
        }
        return result.toString();
    }
}

