/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;

public class IntegerSerializer
implements OrderPreservingSerializer<Integer> {
    private static final long serialVersionUID = 1174998819862504186L;

    @Override
    public Integer read(ScanBuffer buffer) {
        long l = VariableLong.read(buffer);
        Preconditions.checkArgument((l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Invalid serialization [%s]", (Object[])new Object[]{l});
        return (int)l;
    }

    @Override
    public void write(WriteBuffer out, Integer attribute) {
        VariableLong.write(out, attribute.intValue());
    }

    @Override
    public Integer readByteOrder(ScanBuffer buffer) {
        return buffer.getInt() + Integer.MIN_VALUE;
    }

    @Override
    public void writeByteOrder(WriteBuffer out, Integer attribute) {
        out.putInt(attribute - Integer.MIN_VALUE);
    }

    @Override
    public void verifyAttribute(Integer value) {
    }

    @Override
    public Integer convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (Double.isNaN(d) || (double)Math.round(d) != d) {
                throw new IllegalArgumentException("Not a valid integer: " + value);
            }
            long l = ((Number)value).longValue();
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            throw new IllegalArgumentException("Value too large for integer: " + value);
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        return null;
    }
}

