/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.extension;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.furnace.addons.AddonId;

public class AnnotatedCommandExtension
implements Extension {
    private static final Map<AddonId, Set<Method>> annotationMethods = new ConcurrentHashMap<AddonId, Set<Method>>();

    public <T> void observeAnnotationMethods(@Observes ProcessAnnotatedType<T> bean, BeanManager beanManager) {
        AnnotatedType annotatedType = bean.getAnnotatedType();
        AddonId addonId = AddonId.fromCoordinates((String)Thread.currentThread().getName());
        for (AnnotatedMethod annotatedMethod : annotatedType.getMethods()) {
            if (!annotatedMethod.isAnnotationPresent(Command.class)) continue;
            Set<Method> set = annotationMethods.get(addonId);
            if (set == null) {
                set = new HashSet<Method>();
                annotationMethods.put(addonId, set);
            }
            set.add(annotatedMethod.getJavaMember());
        }
    }

    public Set<Method> getAnnotatedCommandMethods() {
        HashSet<Method> set = new HashSet<Method>();
        for (Set<Method> methodSet : annotationMethods.values()) {
            set.addAll(methodSet);
        }
        return set;
    }

    public void addonDestroyed(AddonId addonId) {
        annotationMethods.remove(addonId);
    }
}

