/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.input;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.ui.impl.input.AbstractInputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Callables;

@Vetoed
public class UIInputManyImpl<VALUETYPE>
extends AbstractInputComponent<UIInputMany<VALUETYPE>, VALUETYPE>
implements UIInputMany<VALUETYPE> {
    private Iterable<VALUETYPE> value;
    private Callable<Iterable<VALUETYPE>> defaultValue;
    private UICompleter<VALUETYPE> completer;
    private Converter<String, VALUETYPE> converter;

    public UIInputManyImpl(String name, char shortName, Class<VALUETYPE> type) {
        super(name, shortName, type);
    }

    public UICompleter<VALUETYPE> getCompleter() {
        return this.completer;
    }

    public UIInputMany<VALUETYPE> setCompleter(UICompleter<VALUETYPE> completer) {
        this.completer = completer;
        return this;
    }

    public UIInputMany<VALUETYPE> setValue(Iterable<VALUETYPE> value) {
        Set<ValueChangeListener> listeners = this.getValueChangeListeners();
        if (!listeners.isEmpty() && !InputComponents.areElementsEqual((Iterable)this.getValue(), value)) {
            this.fireValueChangeListeners(value);
        }
        this.value = value;
        return this;
    }

    public UIInputMany<VALUETYPE> setDefaultValue(Callable<Iterable<VALUETYPE>> callback) {
        this.defaultValue = callback;
        return this;
    }

    public UIInputMany<VALUETYPE> setDefaultValue(Iterable<VALUETYPE> value) {
        this.defaultValue = Callables.returning(value);
        return this;
    }

    public Iterable<VALUETYPE> getValue() {
        Iterable iterableValue = this.value == null ? (Iterable)Callables.call(this.defaultValue) : this.value;
        return iterableValue == null ? Collections.emptyList() : iterableValue;
    }

    @Override
    public Converter<String, VALUETYPE> getValueConverter() {
        return this.converter;
    }

    @Override
    public UIInputMany<VALUETYPE> setValueConverter(Converter<String, VALUETYPE> converter) {
        this.converter = converter;
        return this;
    }

    public String toString() {
        return "UIInputManyImpl [name=" + this.getName() + ", shortName='" + this.getShortName() + "', value=" + this.value + ", defaultValue=" + this.defaultValue + "]";
    }

    public boolean hasDefaultValue() {
        Iterable defaultValueValue = (Iterable)Callables.call(this.defaultValue);
        return defaultValueValue != null && defaultValueValue.iterator().hasNext();
    }

    public boolean hasValue() {
        return this.value != null && this.value.iterator().hasNext();
    }
}

