/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jboss.aesh.comparators.PosixFileNameComparator;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.parser.java.resources.JavaFieldResource;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.shell.util.ShellUtil;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class LsCommand
extends AbstractShellCommand {
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;
    @Inject
    @WithAttributes(label="all", shortName=97, description="do not ignore entries starting with .", type="org.jboss.forge.inputType.CHECKBOX", defaultValue="false")
    private UIInput<Boolean> all;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("ls").description("List files");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments).add(this.all);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result;
        List resourceList;
        Iterator it;
        Shell shell = (Shell)context.getUIContext().getProvider();
        Resource currentResource = shell.getCurrentResource();
        Iterator iterator = it = this.arguments.hasValue() ? this.arguments.getValue().iterator() : Collections.emptyIterator();
        if (it.hasNext()) {
            String value = (String)it.next();
            boolean searching = value.matches(".*(\\?|\\*)+.*");
            try {
                resourceList = new ResourcePathResolver(this.resourceFactory, currentResource, value).resolve();
            }
            catch (RuntimeException re) {
                if (re.getMessage() == null || !re.getMessage().contains("no such child")) {
                    throw re;
                }
                return Results.fail((String)(value + ": No such file or directory"));
            }
            if (!searching && !resourceList.isEmpty() && ((Resource)resourceList.get(0)).exists()) {
                resourceList = ((Resource)resourceList.get(0)).listResources();
            }
        } else {
            resourceList = currentResource.listResources();
        }
        if (!resourceList.isEmpty() && !((Resource)resourceList.get(0)).exists()) {
            result = Results.fail((String)(((Resource)resourceList.get(0)).getName() + ": No such file or directory"));
        } else {
            UIOutput output = shell.getOutput();
            output.out().println(this.listMany(resourceList, shell));
            result = Results.success();
        }
        return result;
    }

    private String listMany(Iterable<Resource<?>> resources, Shell shell) {
        if (resources == null) {
            return "";
        }
        TerminalSize terminalSize = shell.getConsole().getShell().getSize();
        ArrayList<FileResource> fileResources = new ArrayList<FileResource>();
        ArrayList<JavaFieldResource> fieldResources = new ArrayList<JavaFieldResource>();
        ArrayList<JavaMethodResource> methodResources = new ArrayList<JavaMethodResource>();
        ArrayList<Resource> otherResources = new ArrayList<Resource>();
        for (Resource<?> resource : resources) {
            if (resource instanceof FileResource) {
                fileResources.add((FileResource)resource);
                continue;
            }
            if (resource instanceof JavaFieldResource) {
                fieldResources.add((JavaFieldResource)resource);
                continue;
            }
            if (resource instanceof JavaMethodResource) {
                methodResources.add((JavaMethodResource)resource);
                continue;
            }
            otherResources.add(resource);
        }
        StringBuilder sb = new StringBuilder();
        if (fileResources.size() > 0) {
            sb.append(this.getFileFormattedList(fileResources, terminalSize.getHeight(), terminalSize.getWidth()));
        }
        if (fieldResources.size() > 0) {
            sb.append(Config.getLineSeparator());
            sb.append(ShellUtil.colorizeLabel("[fields]"));
            sb.append(Config.getLineSeparator());
            sb.append(this.getJavaFieldFormattedList(fieldResources, terminalSize.getHeight(), terminalSize.getWidth()));
        }
        if (methodResources.size() > 0) {
            sb.append(Config.getLineSeparator());
            sb.append(ShellUtil.colorizeLabel("[methods]"));
            sb.append(Config.getLineSeparator());
            sb.append(this.getJavaMethodFormattedList(methodResources, terminalSize.getHeight(), terminalSize.getWidth()));
        }
        if (otherResources.size() > 0) {
            sb.append(this.getFormattedList(otherResources, terminalSize.getHeight(), terminalSize.getWidth()));
        }
        return sb.toString();
    }

    private String getFileFormattedList(List<FileResource> resources, int termHeight, int termWidth) {
        boolean showAll = (Boolean)this.all.getValue();
        ArrayList<TerminalString> display = new ArrayList<TerminalString>();
        for (FileResource resource : resources) {
            if (!showAll && resource.getName().startsWith(".")) continue;
            display.add(ShellUtil.colorizeResourceTerminal(resource));
        }
        Comparator<TerminalString> posixFileNameTerminalComparator = new Comparator<TerminalString>(){
            private PosixFileNameComparator posixFileNameComparator = new PosixFileNameComparator();

            @Override
            public int compare(TerminalString o1, TerminalString o2) {
                return this.posixFileNameComparator.compare(o1.getCharacters(), o2.getCharacters());
            }
        };
        Collections.sort(display, posixFileNameTerminalComparator);
        return Parser.formatDisplayCompactListTerminalString(display, (int)termWidth);
    }

    private String getJavaFieldFormattedList(List<JavaFieldResource> resources, int termHeight, int termWidth) {
        ArrayList<String> display = new ArrayList<String>();
        for (JavaFieldResource resource : resources) {
            display.add(ShellUtil.colorizeJavaFieldResource(resource));
        }
        return Parser.formatDisplayList(display, (int)termHeight, (int)termWidth);
    }

    private String getJavaMethodFormattedList(List<JavaMethodResource> resources, int termHeight, int termWidth) {
        ArrayList<String> display = new ArrayList<String>();
        for (JavaMethodResource resource : resources) {
            display.add(ShellUtil.colorizeJavaMethodResource(resource));
        }
        return Parser.formatDisplayList(display, (int)termHeight, (int)termWidth);
    }

    private String getFormattedList(List<Resource> resources, int termHeight, int termWidth) {
        ArrayList<String> display = new ArrayList<String>();
        for (Resource resource : resources) {
            display.add(resource.getName());
        }
        return Parser.formatDisplayList(display, (int)termHeight, (int)termWidth);
    }
}

