/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.windup.graph.MapInAdjacentVertices;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.exception.WindupException;

public class MapInAdjacentVerticesHandler
implements MethodHandler<MapInAdjacentVertices> {
    public Class<MapInAdjacentVertices> getAnnotationType() {
        return MapInAdjacentVertices.class;
    }

    public Object processElement(Object frame, Method method, Object[] arguments, MapInAdjacentVertices annotation, FramedGraph<?> framedGraph, Element element) {
        if (!(element instanceof Vertex)) {
            throw new WindupException("@" + MapInAdjacentVertices.class.getSimpleName() + " is only supported on Vertexes.");
        }
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.handleGetter((Vertex)element, method, arguments, annotation, framedGraph);
        }
        if (methodName.startsWith("set")) {
            this.handleSetter((Vertex)element, method, arguments, annotation, framedGraph);
            return null;
        }
        throw new WindupException("Only get* and set* method names are supported.");
    }

    private Map<String, WindupVertexFrame> handleGetter(Vertex vertex, Method method, Object[] arguments, MapInAdjacentVertices annotation, FramedGraph<?> framedGraph) {
        if (arguments != null && arguments.length != 0) {
            throw new WindupException("Method must take zero arguments: " + method.getName());
        }
        HashMap<String, WindupVertexFrame> result = new HashMap<String, WindupVertexFrame>();
        Iterable edges = vertex.getEdges(Direction.IN, new String[]{annotation.label()});
        for (Edge edge : edges) {
            String key = (String)edge.getProperty(annotation.mapKeyField());
            Vertex v = edge.getVertex(Direction.OUT);
            WindupVertexFrame frame = (WindupVertexFrame)framedGraph.frame(v, WindupVertexFrame.class);
            result.put(key, frame);
        }
        return result;
    }

    private void handleSetter(Vertex vertex, Method method, Object[] arguments, MapInAdjacentVertices annotation, FramedGraph<?> framedGraph) {
        if (arguments == null || arguments.length != 1) {
            throw new WindupException("Method must take only one argument: " + method.getName());
        }
        Iterable edges = vertex.getEdges(Direction.OUT, new String[]{annotation.label()});
        for (Edge edge : edges) {
            framedGraph.removeEdge(edge);
        }
        Map map = (Map)arguments[0];
        for (Map.Entry entry : map.entrySet()) {
            Edge edge = framedGraph.addEdge(null, ((WindupVertexFrame)entry.getValue()).asVertex(), vertex, annotation.label());
            edge.setProperty(annotation.mapKeyField(), entry.getKey());
        }
    }
}

