/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.man;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.man.FileParser;
import org.jboss.aesh.console.man.TerminalPage;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

public abstract class AeshFileDisplayer
implements Command {
    private int rows;
    private int columns;
    private int topVisibleRow;
    private int topVisibleRowCache;
    private TerminalPage page;
    private StringBuilder number;
    private TerminalPage.Search search = TerminalPage.Search.NO_SEARCH;
    private StringBuilder searchBuilder;
    private List<Integer> searchLines;
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshFileDisplayer.class.getName());
    private CommandInvocation commandInvocation;
    private ControlOperator operation;
    private boolean stop = false;

    protected void setCommandInvocation(CommandInvocation commandInvocation) {
        this.commandInvocation = commandInvocation;
        this.setControlOperator(commandInvocation.getControlOperator());
    }

    protected CommandInvocation getCommandInvocation() {
        return this.commandInvocation;
    }

    protected void setControlOperator(ControlOperator operator) {
        this.operation = operator;
    }

    protected Shell getShell() {
        return this.commandInvocation.getShell();
    }

    protected void afterAttach() throws IOException, InterruptedException {
        this.number = new StringBuilder();
        this.searchBuilder = new StringBuilder();
        this.rows = this.getShell().getSize().getHeight();
        this.columns = this.getShell().getSize().getWidth();
        this.page = new TerminalPage(this.getFileParser(), this.columns);
        this.topVisibleRow = 0;
        this.topVisibleRowCache = -1;
        this.stop = false;
        if (this.operation.isRedirectionOut()) {
            int count = 0;
            for (String line : this.page.getLines()) {
                this.getShell().out().print(line);
                if (++count >= this.page.size()) continue;
                this.getShell().out().print(Config.getLineSeparator());
            }
            this.getShell().out().flush();
            this.afterDetach();
            this.getShell().out().flush();
        } else if (!this.page.hasData()) {
            this.getShell().out().println("error: input is null...");
            this.afterDetach();
        } else {
            this.getShell().out().print(ANSI.getAlternateBufferScreen());
            if (this.page.getFileName() != null) {
                this.display();
            } else {
                this.display();
            }
            this.processInput();
        }
    }

    protected void afterDetach() throws IOException {
        if (!this.operation.isRedirectionOut()) {
            this.getShell().out().print(ANSI.getMainBufferScreen());
        }
        this.page.clear();
        this.topVisibleRow = 0;
    }

    public void processInput() throws IOException, InterruptedException {
        try {
            while (!this.stop) {
                this.processOperation(this.getCommandInvocation().getInput());
            }
        }
        catch (InterruptedException e) {
            this.afterDetach();
            this.stop = true;
            throw e;
        }
    }

    public void processOperation(CommandOperation operation) throws IOException {
        if (operation.getInputKey() == Key.q) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                this.clearNumber();
                this.afterDetach();
                this.stop = true;
            }
        } else if (operation.getInputKey() == Key.j || operation.getInputKey() == Key.DOWN || operation.getInputKey() == Key.DOWN_2 || operation.getInputKey() == Key.ENTER) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (operation.getInputKey() == Key.j) {
                    this.searchBuilder.append((char)operation.getInput()[0]);
                    this.displayBottom();
                } else if (operation.getInputKey() == Key.ENTER) {
                    this.search = TerminalPage.Search.RESULT;
                    this.findSearchWord(true);
                }
            } else if (this.search == TerminalPage.Search.NOT_FOUND) {
                if (operation.getInputKey() == Key.ENTER) {
                    this.search = TerminalPage.Search.NO_SEARCH;
                    this.clearBottomLine();
                    this.displayBottom();
                }
            } else {
                this.topVisibleRow += this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation.getInputKey() == Key.k || operation.getInputKey() == Key.UP || operation.getInputKey() == Key.UP_2) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (operation.getInputKey() == Key.k) {
                    this.searchBuilder.append((char)operation.getInput()[0]);
                }
                this.displayBottom();
            } else {
                this.topVisibleRow -= this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation.getInputKey() == Key.CTRL_F || operation.getInputKey() == Key.PGDOWN || operation.getInputKey() == Key.SPACE) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow += (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (operation.getInputKey() == Key.CTRL_B || operation.getInputKey() == Key.PGUP) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow -= (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (operation.getInputKey() == Key.SLASH) {
            if (this.search == TerminalPage.Search.NO_SEARCH || this.search == TerminalPage.Search.RESULT) {
                this.search = TerminalPage.Search.SEARCHING;
                this.searchBuilder = new StringBuilder();
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            }
        } else if (operation.getInputKey() == Key.n) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT) {
                if (this.searchLines.size() > 0) {
                    for (Integer i : this.searchLines) {
                        if (i <= this.topVisibleRow + 1) continue;
                        this.topVisibleRow = i - 1;
                        this.display();
                        return;
                    }
                    this.displayBottom();
                } else {
                    this.displayBottom();
                }
            }
        } else if (operation.getInputKey() == Key.N) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                for (int i = this.searchLines.size() - 1; i >= 0; --i) {
                    if (this.searchLines.get(i) >= this.topVisibleRow) continue;
                    this.topVisibleRow = this.searchLines.get(i) - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                    return;
                }
                this.displayBottom();
            }
        } else if (operation.getInputKey() == Key.G) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                if (this.number.length() == 0 || this.getNumber() == 0) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    this.display();
                } else {
                    this.topVisibleRow = this.getNumber() - 1;
                    if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                        this.topVisibleRow = this.page.size() - this.rows - 1;
                        this.display();
                    } else {
                        this.display();
                    }
                }
                this.clearNumber();
            }
        } else if (operation.getInputKey().isNumber()) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)operation.getInput()[0]);
                this.displayBottom();
            } else {
                this.number.append(Character.getNumericValue(operation.getInput()[0]));
                this.display();
            }
        } else if (this.search == TerminalPage.Search.SEARCHING && Character.isAlphabetic(operation.getInput()[0])) {
            this.searchBuilder.append((char)operation.getInput()[0]);
            this.displayBottom();
        }
    }

    private void display() throws IOException {
        if (this.topVisibleRow != this.topVisibleRowCache) {
            this.getShell().clear();
            if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                String searchWord = this.searchBuilder.toString();
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    String line = this.page.getLine(i);
                    if (line.contains(searchWord)) {
                        this.displaySearchLine(line, searchWord);
                    } else {
                        this.getShell().out().print(line);
                    }
                    this.getShell().out().print(Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            } else {
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    this.getShell().out().print(this.page.getLine(i) + Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            }
            this.displayBottom();
        }
        this.getShell().out().flush();
    }

    private void displaySearchLine(String line, String searchWord) throws IOException {
        int start = line.indexOf(searchWord);
        this.getShell().out().print(line.substring(0, start));
        this.getShell().out().print(ANSI.getInvertedBackground());
        this.getShell().out().print(searchWord);
        this.getShell().out().print(ANSI.reset());
        this.getShell().out().print(line.substring(start + searchWord.length(), line.length()));
        this.getShell().out().flush();
    }

    public abstract FileParser getFileParser();

    public abstract void displayBottom() throws IOException;

    public void writeToConsole(String word) throws IOException {
        this.getShell().out().print(word);
        this.getShell().out().flush();
    }

    public void clearBottomLine() throws IOException {
        this.getShell().out().print(Buffer.printAnsi("0G"));
        this.getShell().out().print(Buffer.printAnsi("2K"));
        this.getShell().out().flush();
    }

    public boolean isAtBottom() {
        return this.topVisibleRow >= this.page.size() - this.rows - 1;
    }

    public boolean isAtTop() {
        return this.topVisibleRow == 0;
    }

    public TerminalPage.Search getSearchStatus() {
        return this.search;
    }

    public String getSearchWord() {
        return this.searchBuilder.toString();
    }

    public int getTopVisibleRow() {
        return this.topVisibleRow + 1;
    }

    private void findSearchWord(boolean forward) throws IOException {
        LOGGER.info("searching for: " + this.searchBuilder.toString());
        this.searchLines = this.page.findWord(this.searchBuilder.toString());
        LOGGER.info("found: " + this.searchLines);
        if (this.searchLines.size() > 0) {
            for (Integer i : this.searchLines) {
                if (i <= this.topVisibleRow) continue;
                this.topVisibleRow = i - 1;
                this.display();
                return;
            }
        } else {
            this.search = TerminalPage.Search.NOT_FOUND;
            this.displayBottom();
        }
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

