/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.util.datastructures.Interval;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ProperInterval<T>
implements Interval<T> {
    private boolean startInclusive = true;
    private boolean endInclusive = true;
    private T start = null;
    private T end = null;

    public ProperInterval() {
    }

    public ProperInterval(T point) {
        this();
        this.setPoint(point);
    }

    public ProperInterval(T start, T end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setPoint(T point) {
        Preconditions.checkNotNull(point);
        this.start = point;
        this.end = point;
        this.startInclusive = true;
        this.endInclusive = true;
    }

    public void setStart(T start) {
        Preconditions.checkArgument((boolean)(start instanceof Comparable));
        this.start = start;
    }

    public void setEnd(T end) {
        Preconditions.checkArgument((boolean)(end instanceof Comparable));
        this.end = end;
    }

    public void setStartInclusive(boolean inclusive) {
        Preconditions.checkArgument((this.start == null || this.start instanceof Comparable ? 1 : 0) != 0);
        this.startInclusive = inclusive;
    }

    public void setEndInclusive(boolean inclusive) {
        Preconditions.checkArgument((this.end == null || this.end instanceof Comparable ? 1 : 0) != 0);
        this.endInclusive = inclusive;
    }

    @Override
    public T getStart() {
        return this.start;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public boolean startInclusive() {
        return this.startInclusive;
    }

    @Override
    public boolean endInclusive() {
        return this.endInclusive;
    }

    @Override
    public boolean isPoint() {
        return this.start != null && this.end != null && this.start.equals(this.end) && this.startInclusive && this.endInclusive;
    }

    @Override
    public boolean isEmpty() {
        if (this.start == null || this.end == null) {
            return false;
        }
        if (this.isPoint()) {
            return false;
        }
        int cmp = ((Comparable)this.start).compareTo(this.end);
        return cmp > 0 || cmp == 0 && (!this.startInclusive || !this.endInclusive);
    }

    public boolean contains(T other) {
        int cmp;
        Preconditions.checkNotNull(other);
        if (this.isPoint()) {
            return this.start.equals(other);
        }
        if (this.start != null && ((cmp = ((Comparable)this.start).compareTo(other)) > 0 || cmp == 0 && !this.startInclusive)) {
            return false;
        }
        return this.end == null || (cmp = ((Comparable)this.end).compareTo(other)) >= 0 && (cmp != 0 || this.endInclusive);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.start).append(this.end).append(this.startInclusive).append(this.endInclusive).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        ProperInterval oth = (ProperInterval)other;
        if (this.start == null ^ oth.start == null || this.end == null ^ oth.end == null) {
            return false;
        }
        return this.start.equals(oth.start) && this.end.equals(oth.end) && this.endInclusive == oth.endInclusive && this.startInclusive == oth.startInclusive;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.startInclusive) {
            b.append("[");
        } else {
            b.append("(");
        }
        b.append(this.start).append(",").append(this.end);
        if (this.endInclusive) {
            b.append("]");
        } else {
            b.append(")");
        }
        return b.toString();
    }
}

