/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools;

import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class CloseableTupleQueryResult
implements TupleQueryResult {
    private RepositoryConnection connection;
    private TupleQueryResult result;

    public CloseableTupleQueryResult(RepositoryConnection connection, TupleQueryResult result) {
        this.connection = connection;
        this.result = result;
    }

    public List<String> getBindingNames() throws QueryEvaluationException {
        return this.result.getBindingNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws QueryEvaluationException {
        try {
            this.result.close();
        }
        finally {
            try {
                this.connection.close();
            }
            catch (RepositoryException e) {
                throw new QueryEvaluationException("Exception closing connection.", (Throwable)e);
            }
        }
    }

    public boolean hasNext() throws QueryEvaluationException {
        boolean hasNext = this.result.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public BindingSet next() throws QueryEvaluationException {
        return (BindingSet)this.result.next();
    }

    public void remove() throws QueryEvaluationException {
        this.result.remove();
    }
}

