/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.ContainerStatus;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.LockManagerImpl;
import org.jboss.forge.furnace.impl.LoggingRepair;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonRegistryImpl;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.impl.addons.ImmutableAddonRepository;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.modules.Module;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.StreamModuleLogger;

public class FurnaceImpl
implements Furnace {
    private static Logger logger = Logger.getLogger(FurnaceImpl.class.getName());
    private volatile boolean alive = false;
    private volatile ContainerStatus status = ContainerStatus.STOPPED;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private boolean serverMode = true;
    private AddonLifecycleManager manager;
    private final List<ContainerLifecycleListener> registeredListeners = new ArrayList<ContainerLifecycleListener>();
    private final List<ListenerRegistration<ContainerLifecycleListener>> loadedListenerRegistrations = new ArrayList<ListenerRegistration<ContainerLifecycleListener>>();
    private ClassLoader loader;
    private final List<AddonRepository> repositories = new ArrayList<AddonRepository>();
    private final Map<AddonRepository, Integer> lastRepoVersionSeen = new HashMap<AddonRepository, Integer>();
    private final LockManager lock = new LockManagerImpl();
    private String[] args;
    private int registryCount = 0;
    private WatchService watcher;

    public FurnaceImpl() {
        if (!AddonRepositoryImpl.hasRuntimeAPIVersion()) {
            logger.warning("Could not detect Furnace runtime version - loading all addons, but failures may occur if versions are not compatible.");
        }
        if (!Boolean.getBoolean("furnace.logging.leak")) {
            LoggingRepair.init();
        }
        if (Boolean.getBoolean("furnace.debug")) {
            this.enableLogging();
        }
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "File monitoring could not be started.", e);
        }
    }

    public LockManager getLockManager() {
        return this.lock;
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.loader;
    }

    public Furnace enableLogging() {
        this.assertNotAlive();
        Module.setModuleLogger((ModuleLogger)new StreamModuleLogger(System.err));
        return this;
    }

    public Future<Furnace> startAsync() {
        return this.startAsync(FurnaceImpl.class.getClassLoader());
    }

    public Future<Furnace> startAsync(final ClassLoader loader) {
        return this.executor.submit(new Callable<Furnace>(){

            @Override
            public Furnace call() throws Exception {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("Furnace Container " + FurnaceImpl.this);
                        FurnaceImpl.this.start(loader);
                    }
                };
                thread.start();
                while (!ContainerStatus.STARTED.equals((Object)FurnaceImpl.this.getStatus())) {
                    Thread.sleep(25L);
                }
                return FurnaceImpl.this;
            }
        });
    }

    public void start() {
        this.start(FurnaceImpl.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClassLoader loader) {
        logger.log(Level.INFO, "Furnace [" + AddonRepositoryImpl.getRuntimeAPIVersion() + "] starting.");
        this.assertNotAlive();
        this.alive = true;
        this.loader = loader;
        for (ContainerLifecycleListener listener : ServiceLoader.load(ContainerLifecycleListener.class, loader)) {
            ListenerRegistration<ContainerLifecycleListener> registration = this.addContainerLifecycleListener(listener);
            this.loadedListenerRegistrations.add(registration);
        }
        this.fireBeforeContainerStartedEvent();
        try {
            this.getAddonRegistry(new AddonRepository[0]);
            do {
                boolean dirty = false;
                if (!this.getLifecycleManager().isStartingAddons()) {
                    for (AddonRepository repository : this.repositories) {
                        int repoVersion = repository.getVersion();
                        if (repoVersion <= this.lastRepoVersionSeen.get(repository)) continue;
                        logger.log(Level.INFO, "Detected changes in repository [" + repository + "].");
                        this.lastRepoVersionSeen.put(repository, repoVersion);
                        dirty = true;
                    }
                    WatchKey key = this.watcher.poll();
                    while (key != null) {
                        List<WatchEvent<?>> events = key.pollEvents();
                        if (!events.isEmpty()) {
                            logger.log(Level.INFO, "Detected changes in repository [" + events.iterator().next().context() + "].");
                            dirty = true;
                        }
                        key.reset();
                        key = this.watcher.poll();
                    }
                    if (dirty) {
                        try {
                            this.fireBeforeConfigurationScanEvent();
                            this.getLifecycleManager().forceUpdate();
                            this.fireAfterConfigurationScanEvent();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error occurred.", e);
                        }
                    }
                }
                this.status = ContainerStatus.STARTED;
                Thread.sleep(100L);
            } while (this.alive && this.serverMode);
            while (this.alive && this.getLifecycleManager().isStartingAddons()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error occurred.", e);
        }
        finally {
            this.fireBeforeContainerStoppedEvent();
            this.status = ContainerStatus.STOPPED;
            this.getLifecycleManager().stopAll();
        }
        this.fireAfterContainerStoppedEvent();
        this.cleanup();
    }

    private void cleanup() {
        for (ListenerRegistration<ContainerLifecycleListener> registation : this.loadedListenerRegistrations) {
            registation.removeListener();
        }
        this.registeredListeners.clear();
        this.lastRepoVersionSeen.clear();
        this.loader = null;
        this.manager.dispose();
        this.manager = null;
        this.repositories.clear();
        this.executor.shutdownNow();
    }

    private void fireBeforeConfigurationScanEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeConfigurationScan((Furnace)this);
        }
    }

    private void fireAfterConfigurationScanEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.afterConfigurationScan((Furnace)this);
        }
    }

    private void fireBeforeContainerStartedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeStart((Furnace)this);
        }
    }

    private void fireBeforeContainerStoppedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.beforeStop((Furnace)this);
        }
    }

    private void fireAfterContainerStoppedEvent() {
        for (ContainerLifecycleListener listener : this.registeredListeners) {
            listener.afterStop((Furnace)this);
        }
    }

    public Furnace stop() {
        this.alive = false;
        return this;
    }

    public void setArgs(String[] args) {
        this.assertNotAlive();
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public Furnace setServerMode(boolean server) {
        this.assertNotAlive();
        this.serverMode = server;
        return this;
    }

    public AddonRegistry getAddonRegistry(AddonRepository ... repositories) {
        this.assertIsAlive();
        AddonRegistry result = this.getLifecycleManager().findView(repositories);
        if (result == null) {
            if (repositories == null || repositories.length == 0) {
                result = new AddonRegistryImpl(this.lock, this.getLifecycleManager(), this.getRepositories(), "ROOT");
                this.getLifecycleManager().addView((AddonView)result);
            } else {
                result = new AddonRegistryImpl(this.lock, this.getLifecycleManager(), Arrays.asList(repositories), String.valueOf(this.registryCount++));
                this.getLifecycleManager().addView((AddonView)result);
                this.getLifecycleManager().forceUpdate();
            }
        }
        return result;
    }

    public void disposeAddonView(AddonView view) {
        this.assertIsAlive();
        if (this.getAddonRegistry(new AddonRepository[0]).equals(view)) {
            throw new IllegalArgumentException("Cannot dispose the root AddonRegistry. Call .stop() instead.");
        }
        this.getLifecycleManager().removeView(view);
        this.getLifecycleManager().forceUpdate();
    }

    public Version getVersion() {
        return AddonRepositoryImpl.getRuntimeAPIVersion();
    }

    public ListenerRegistration<ContainerLifecycleListener> addContainerLifecycleListener(final ContainerLifecycleListener listener) {
        this.registeredListeners.add(listener);
        return new ListenerRegistration<ContainerLifecycleListener>(){

            public ContainerLifecycleListener removeListener() {
                FurnaceImpl.this.registeredListeners.remove(listener);
                return listener;
            }
        };
    }

    public List<AddonRepository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public AddonRepository addRepository(AddonRepositoryMode mode, File directory) {
        Assert.notNull((Object)mode, (String)"Addon repository mode must not be null.");
        Assert.notNull((Object)directory, (String)"Addon repository directory must not be null.");
        Object repository = AddonRepositoryImpl.forDirectory(this, directory);
        if (mode.isImmutable()) {
            repository = new ImmutableAddonRepository((AddonRepository)repository);
        } else {
            try {
                if (this.watcher != null) {
                    if (directory.exists() && directory.isDirectory() || directory.mkdirs()) {
                        directory.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
                        logger.log(Level.INFO, "Monitoring repository [" + directory.toString() + "] for file changes.");
                    } else {
                        logger.log(Level.WARNING, "Cannot monitor repository [" + directory + "] for changes because it is not a directory.");
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not monitor repository [" + directory.toString() + "] for file changes.", e);
            }
        }
        return this.addRepository((AddonRepository)repository);
    }

    public AddonRepository addRepository(AddonRepository repository) {
        Assert.notNull((Object)repository, (String)"Addon repository must not be null.");
        for (AddonRepository registeredRepo : this.repositories) {
            if (!registeredRepo.getRootDirectory().equals(repository.getRootDirectory())) continue;
            return registeredRepo;
        }
        this.repositories.add(repository);
        this.lastRepoVersionSeen.put(repository, 0);
        return repository;
    }

    public void assertIsAlive() {
        if (!this.alive) {
            throw new IllegalStateException("Cannot access this method until Furnace is running. Call .start() or .startAsync() first.");
        }
    }

    public void assertNotAlive() {
        if (this.alive) {
            throw new IllegalStateException("Cannot modify a running Furnace instance. Call .stop() first.");
        }
    }

    public ContainerStatus getStatus() {
        if (!this.alive) {
            return ContainerStatus.STOPPED;
        }
        boolean startingAddons = this.getLifecycleManager().isStartingAddons();
        return startingAddons ? ContainerStatus.STARTING : this.status;
    }

    public List<ContainerLifecycleListener> getRegisteredListeners() {
        return Collections.unmodifiableList(this.registeredListeners);
    }

    public AddonLifecycleManager getAddonLifecycleManager() {
        return this.getLifecycleManager();
    }

    public String toString() {
        return this.getLifecycleManager().toString();
    }

    private AddonLifecycleManager getLifecycleManager() {
        if (this.manager == null) {
            this.manager = new AddonLifecycleManager(this);
        }
        return this.manager;
    }

    public boolean isTestMode() {
        return Boolean.getBoolean("org.jboss.forge.furnace.test");
    }
}

