/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.impl.addons.AddonRunnable;
import org.jboss.forge.furnace.impl.addons.AddonState;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.impl.graph.MasterGraph;
import org.jboss.forge.furnace.impl.modules.AddonModuleLoader;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;

public class AddonStateManager {
    private final LockManager lock;
    private MasterGraph graph;
    private final Map<Addon, AddonState> states = new HashMap<Addon, AddonState>();
    private AddonModuleLoader loader;

    public AddonStateManager(LockManager lock) {
        this.lock = lock;
    }

    public void dispose() {
        this.graph = null;
        this.states.clear();
        this.loader = null;
    }

    public void setModuleLoader(AddonModuleLoader loader) {
        this.loader = loader;
    }

    public Set<AddonDependency> getDependenciesOf(Addon addon) {
        return this.getState(addon).getDependencies();
    }

    public Set<AddonDependency> getMissingDependenciesOf(Addon addon) {
        return this.getState(addon).getMissingDependencies();
    }

    public ClassLoader getClassLoaderOf(Addon addon) {
        return this.getState(addon).getClassLoader();
    }

    public EventManager getEventManagerOf(Addon addon) {
        return this.getState(addon).getEventManager();
    }

    public Future<Void> getFutureOf(Addon addon) {
        return this.getState(addon).getFuture();
    }

    public AddonRepository getRepositoryOf(Addon addon) {
        return this.getState(addon).getRepository();
    }

    public AddonRunnable getRunnableOf(Addon addon) {
        return this.getState(addon).getRunnable();
    }

    public ServiceRegistry getServiceRegistryOf(Addon addon) {
        return this.getState(addon).getServiceRegistry();
    }

    public Set<AddonView> getViewsOf(final Addon addon) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<AddonView>>(){

            @Override
            public Set<AddonView> call() throws Exception {
                HashSet<AddonView> result = new HashSet<AddonView>();
                for (AddonVertex vertex : AddonStateManager.this.getCurrentGraph().getGraph().vertexSet()) {
                    if (!addon.equals(vertex.getAddon())) continue;
                    result.addAll(vertex.getViews());
                    break;
                }
                return result;
            }
        });
    }

    private AddonState getState(final Addon addon) {
        return (AddonState)this.lock.performLocked(LockMode.READ, (Callable)new Callable<AddonState>(){

            @Override
            public AddonState call() throws Exception {
                AddonState result = (AddonState)AddonStateManager.this.states.get(addon);
                if (result == null) {
                    result = new AddonState();
                }
                return result;
            }
        });
    }

    public void setState(final Addon addon, final AddonState state) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.states.put(addon, state);
                return null;
            }
        });
    }

    public MasterGraph getCurrentGraph() {
        return (MasterGraph)this.lock.performLocked(LockMode.READ, (Callable)new Callable<MasterGraph>(){

            @Override
            public MasterGraph call() throws Exception {
                return AddonStateManager.this.graph != null ? AddonStateManager.this.graph : new MasterGraph();
            }
        });
    }

    public void setCurrentGraph(final MasterGraph update) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.graph = update;
                return null;
            }
        });
    }

    public AddonId resolveAddonId(Set<AddonView> views, String name) {
        Assert.notNull(views, (String)"Views must not be null.");
        Assert.isTrue((!views.isEmpty() ? 1 : 0) != 0, (String)"Views must not be empty.");
        Assert.notNull((Object)name, (String)"Addon name must not be null.");
        AddonId result = null;
        AddonView view = views.iterator().next();
        for (AddonId id : this.getAllEnabled(view.getRepositories())) {
            if (!name.equals(id.getName()) || result != null && id.getVersion().compareTo((Object)result.getVersion()) < 0) continue;
            result = id;
        }
        return result;
    }

    private Set<AddonId> getAllEnabled(Set<AddonRepository> repositories) {
        HashSet<AddonId> result = new HashSet<AddonId>();
        for (AddonRepository repository : repositories) {
            for (AddonId enabled : repository.listEnabled()) {
                result.add(enabled);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Addon addon) {
        boolean result = false;
        try {
            try {
                AddonRunnable runnable = this.getRunnableOf(addon);
                if (runnable != null) {
                    runnable.shutdown();
                }
            }
            finally {
                Future<Void> future = this.getFutureOf(addon);
                if (future != null && !future.isDone()) {
                    result = future.cancel(true);
                }
                if (future.isDone()) {
                    result = true;
                }
            }
        }
        finally {
            if (this.loader != null) {
                this.loader.releaseAddonModule(addon);
            }
            this.reset(addon);
        }
        return result;
    }

    private void reset(final Addon addon) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.states.remove(addon);
                return null;
            }
        });
    }

    public boolean canBeStarted(Addon addon) {
        return this.getRunnableOf(addon) == null && addon.getStatus().isLoaded();
    }

    public void setHandles(final Addon addon, final Future<Void> result, final AddonRunnable runnable) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.getState(addon).setFuture(result);
                AddonStateManager.this.getState(addon).setRunnable(runnable);
                return null;
            }
        });
    }

    public void setEventManager(final Addon addon, final EventManager manager) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.getState(addon).setEventManager(manager);
                return null;
            }
        });
    }

    public void setServiceRegistry(final Addon addon, final ServiceRegistry registry) {
        this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AddonStateManager.this.getState(addon).setServiceRegistry(registry);
                return null;
            }
        });
    }
}

