/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.Version;

public class AddonVertex {
    private final String name;
    private final Version version;
    private final Set<AddonView> views = new HashSet<AddonView>();
    private Addon addon;
    private boolean dirty;

    public AddonVertex(String name, Version version) {
        Assert.notNull((Object)name, (String)"Name must not be null.");
        Assert.notNull((Object)version, (String)"Version must not be null.");
        this.name = name;
        this.version = version;
    }

    public AddonVertex(AddonVertex source, AddonView view) {
        this.name = source.name;
        this.version = source.version;
        this.views.addAll(source.getViews());
        this.views.add(view);
        this.addon = source.addon;
        this.dirty = source.dirty;
    }

    public Addon getAddon() {
        return this.addon;
    }

    public void setAddon(Addon addon) {
        this.addon = addon;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Set<AddonView> getViews() {
        return Collections.unmodifiableSet(this.views);
    }

    public AddonId getAddonId() {
        return AddonId.from((String)this.name, (Version)this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.views == null ? 0 : this.views.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonVertex other = (AddonVertex)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return !(this.views == null ? other.views != null : !this.views.equals(other.views));
    }

    public String toString() {
        return "[" + this.name + "," + this.version + "]";
    }
}

