/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.modules;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.modules.ModuleIdentifier;

class AddonModuleJarFileCache {
    private static final Logger logger = Logger.getLogger(AddonModuleJarFileCache.class.getName());
    private final Map<ModuleIdentifier, Set<JarFile>> map = new ConcurrentHashMap<ModuleIdentifier, Set<JarFile>>();

    AddonModuleJarFileCache() {
    }

    public void closeJarFileReferences(ModuleIdentifier id) {
        Assert.notNull((Object)id, (String)"Module reference must not be null.");
        Set<JarFile> files = this.map.remove(id);
        if (files != null) {
            for (JarFile file : files) {
                try {
                    logger.log(Level.FINE, "Closing JarFile [" + file.getName() + "]");
                    file.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Could not close JAR file reference [" + file + "] for module [" + id + "]", e);
                }
            }
        }
    }

    public void addJarFileReference(ModuleIdentifier id, JarFile file) {
        Assert.notNull((Object)id, (String)"Module reference must not be null.");
        Assert.notNull((Object)file, (String)"JarFile reference must not be null.");
        logger.log(Level.FINE, "Adding JarFile [" + file.getName() + "] for module [" + id + "]");
        Set files = this.map.get(id);
        if (files == null) {
            files = Sets.getConcurrentSet();
            this.map.put(id, files);
        }
        files.add(file);
    }

    public void dispose() {
        for (ModuleIdentifier id : this.map.keySet()) {
            this.closeJarFileReferences(id);
        }
        this.map.clear();
    }
}

