/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import com.tinkerpop.blueprints.Vertex;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.query.FindFilesNotClassifiedOrHintedGremlinCriterion;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;

public class FindFilesNotClassifiedOrHinted
implements WindupFreeMarkerMethod {
    private GraphContext context;

    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<FileModel>)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        Iterable fileModels = (Iterable)stringModelArg.getWrappedObject();
        FindFilesNotClassifiedOrHintedGremlinCriterion criterion = new FindFilesNotClassifiedOrHintedGremlinCriterion();
        ArrayList<Vertex> initialFileModelsAsVertices = new ArrayList<Vertex>();
        for (FileModel fm : fileModels) {
            initialFileModelsAsVertices.add(fm.asVertex());
        }
        Iterable result = criterion.query(this.context, initialFileModelsAsVertices);
        ArrayList<FileModel> resultModels = new ArrayList<FileModel>();
        for (Vertex v : result) {
            FileModel f = (FileModel)this.context.getFramed().frame(v, FileModel.class);
            if (!(f instanceof JavaSourceFileModel) && !(f instanceof XmlFileModel)) continue;
            resultModels.add(f);
        }
        return resultModels;
    }

    public String getMethodName() {
        return "findFilesNotClassifiedOrHinted";
    }
}

