/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.Property;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.io.InputStream;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.w3c.dom.Document;

@TypeValue(value="XmlFileModel")
public interface XmlFileModel
extends FileModel,
SourceFileModel {
    public static final String UNPARSEABLE_XML_CLASSIFICATION = "Unparseable XML File";
    public static final String UNPARSEABLE_XML_DESCRIPTION = "This file could not be parsed";
    public static final String ROOT_TAG_NAME = "rootTagName";
    public static final String NAMESPACE = "namespace";
    public static final String DOCTYPE = "doctype";
    public static final String TYPE = "XmlFileModel";

    @Adjacency(label="doctype", direction=Direction.OUT)
    public void setDoctype(DoctypeMetaModel var1);

    @Adjacency(label="doctype", direction=Direction.OUT)
    public DoctypeMetaModel getDoctype();

    @Adjacency(label="namespace", direction=Direction.OUT)
    public void addNamespace(NamespaceMetaModel var1);

    @Adjacency(label="namespace", direction=Direction.OUT)
    public Iterable<NamespaceMetaModel> getNamespaces();

    @Property(value="rootTagName")
    public String getRootTagName();

    @Property(value="rootTagName")
    public void setRootTagName(String var1);

    @JavaHandler
    public Document asDocument();

    public static abstract class Impl
    implements XmlFileModel,
    JavaHandlerContext<Vertex> {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Document asDocument() {
            FileModel fileModel = (FileModel)this.frame(this.asVertex(), FileModel.class);
            try (InputStream is = fileModel.asInputStream();){
                Document parsedDocument;
                Document document = parsedDocument = LocationAwareXmlReader.readXML((InputStream)is);
                return document;
            }
            catch (Exception e) {
                throw new WindupException("Exception reading document.", (Throwable)e);
            }
        }
    }
}

