/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredEntrySet;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredKeySet;
import com.sleepycat.collections.StoredSortedEntrySet;
import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.StoredSortedValueSet;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.je.Database;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredMap<K, V>
extends StoredContainer
implements ConcurrentMap<K, V> {
    private StoredKeySet<K> keySet;
    private StoredEntrySet<K, V> entrySet;
    private StoredValueSet<V> valueSet;

    public StoredMap(Database database, EntryBinding<K> keyBinding, EntryBinding<V> valueBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, valueBinding, null, writeAllowed, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> keyBinding, EntryBinding<V> valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, valueBinding, null, true, keyAssigner));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> keyBinding, EntityBinding<V> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, writeAllowed, null));
        this.initView();
    }

    public StoredMap(Database database, EntryBinding<K> keyBinding, EntityBinding<V> valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, keyBinding, null, valueEntityBinding, true, keyAssigner));
        this.initView();
    }

    StoredMap(DataView view) {
        super(view);
        this.initView();
    }

    @Override
    void initAfterClone() {
        this.initView();
    }

    private void initView() {
        this.entrySet = this.areKeyRangesAllowed() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
        DataView newView = this.view.keySetView();
        this.keySet = this.areKeyRangesAllowed() ? new StoredSortedKeySet(newView) : new StoredKeySet(newView);
        newView = this.view.valueSetView();
        this.valueSet = this.areKeyRangesAllowed() && newView.canDeriveKeyFromValue() ? new StoredSortedValueSet<V>(newView) : new StoredValueSet(newView);
    }

    @Override
    public V get(Object key) {
        return (V)this.getValue(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.putKeyValue(key, value);
    }

    public K append(V value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return (K)key[0];
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public V remove(Object key) {
        Object[] oldVal = new Object[1];
        this.removeKey(key, oldVal);
        return (V)oldVal[0];
    }

    @Override
    public V putIfAbsent(K key, V value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object oldValue;
            block3: {
                OperationStatus status;
                cursor = new DataCursor(this.view, true);
                do {
                    if ((status = cursor.putNoOverwrite(key, value, false)) != OperationStatus.SUCCESS) continue;
                    oldValue = null;
                    break block3;
                } while ((status = cursor.getSearchKey(key, null, false)) != OperationStatus.SUCCESS);
                oldValue = cursor.getCurrentValue();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return (V)oldValue;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean removed;
            cursor = new DataCursor(this.view, true, key);
            OperationStatus status = cursor.getFirst(true);
            if (status == OperationStatus.SUCCESS && cursor.getCurrentValue().equals(value)) {
                cursor.delete();
                removed = true;
            } else {
                removed = false;
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return removed;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public V replace(K key, V value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object oldValue;
            cursor = new DataCursor(this.view, true, key);
            OperationStatus status = cursor.getFirst(true);
            if (status == OperationStatus.SUCCESS) {
                oldValue = cursor.getCurrentValue();
                cursor.putCurrent(value);
            } else {
                oldValue = null;
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return (V)oldValue;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean replaced;
            cursor = new DataCursor(this.view, true, key);
            OperationStatus status = cursor.getFirst(true);
            if (status == OperationStatus.SUCCESS && cursor.getCurrentValue().equals(oldValue)) {
                cursor.putCurrent(newValue);
                replaced = true;
            } else {
                replaced = false;
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return replaced;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        boolean doAutoCommit = this.beginAutoCommit();
        Iterator i = null;
        try {
            Set<Map.Entry<? extends K, ? extends V>> coll = map.entrySet();
            i = this.storedOrExternalIterator(coll);
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                this.putKeyValue(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        return this.valueSet;
    }

    public Collection<V> duplicates(K key) {
        try {
            DataView newView = this.view.valueSetView(key);
            return new StoredValueSet(newView);
        }
        catch (KeyRangeException e) {
            return Collections.EMPTY_SET;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public <PK> Map<PK, V> duplicatesMap(K secondaryKey, EntryBinding primaryKeyBinding) {
        try {
            DataView newView = this.view.duplicatesView(secondaryKey, primaryKeyBinding);
            if (this.isOrdered()) {
                return new StoredSortedMap(newView);
            }
            return new StoredMap<K, V>(newView);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Map) {
            return this.entrySet().equals(((Map)other).entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int size() {
        return this.values().size();
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

