/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.FeederReader;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;

public class MasterFeederSource
implements FeederSource {
    private final FeederReader feederReader;

    public MasterFeederSource(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, NameIdPair nameIdPair) throws DatabaseException {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.feederReader = new FeederReader(envImpl, vlsnIndex, -1L, readBufferSize, nameIdPair);
    }

    public void init(VLSN startVLSN) throws DatabaseException, IOException {
        this.feederReader.initScan(startVLSN);
    }

    public OutputWireRecord getWireRecord(VLSN vlsn, int waitTime) throws DatabaseException, InterruptedException, IOException {
        try {
            return this.feederReader.scanForwards(vlsn, waitTime);
        }
        catch (DatabaseException e) {
            e.addErrorMessage("MasterFeederSource fetching vlsn=" + vlsn + " waitTime=" + waitTime);
            throw e;
        }
    }

    public String dumpState() {
        return this.feederReader.dumpState();
    }
}

