/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.util.LogVerificationException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class LogVerificationInputStream
extends InputStream {
    private static final int SKIP_BUF_SIZE = 2048;
    private static final byte FILE_HEADER_TYPE_NUM = LogEntryType.LOG_FILE_HEADER.getTypeNum();
    private final EnvironmentImpl envImpl;
    private final InputStream in;
    private final String fileName;
    private final long fileNum;
    private byte[] skipBuf;
    private State state;
    private long entryStart;
    private long prevEntryStart;
    private final ChecksumValidator validator;
    private final ByteBuffer headerBuf;
    private LogEntryHeader header;
    private int itemPosition;
    private int logVersion;

    public LogVerificationInputStream(Environment env, InputStream in, String fileName) {
        this(DbInternal.getEnvironmentImpl(env), in, fileName, -1L);
    }

    LogVerificationInputStream(EnvironmentImpl envImpl, InputStream in, String fileName, long fileNum) {
        this.envImpl = envImpl;
        this.in = in;
        this.fileName = fileName;
        this.fileNum = fileNum >= 0L ? fileNum : envImpl.getFileManager().getNumFromName(fileName);
        this.state = State.INIT;
        this.entryStart = 0L;
        this.prevEntryStart = 0L;
        this.validator = new ChecksumValidator();
        this.headerBuf = ByteBuffer.allocate(Math.max(22, FileHeader.entrySize()));
        this.logVersion = -1;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c < 0) {
            this.verifyAtEof();
            return c;
        }
        this.verify(new byte[]{(byte)c}, 0, 1);
        return c;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int lenRead = this.in.read(b, off, len);
        if (lenRead <= 0) {
            if (lenRead < 0) {
                this.verifyAtEof();
            }
            return lenRead;
        }
        this.verify(b, off, lenRead);
        return lenRead;
    }

    public long skip(long bytesToSkip) throws IOException {
        long remaining;
        int lenRead;
        if (bytesToSkip <= 0L) {
            return 0L;
        }
        if (this.skipBuf == null) {
            this.skipBuf = new byte[2048];
        }
        for (remaining = bytesToSkip; remaining > 0L && (lenRead = this.read(this.skipBuf, 0, (int)Math.min(2048L, remaining))) >= 0; remaining -= (long)lenRead) {
        }
        return bytesToSkip - remaining;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        if (this.state != State.INVALID) {
            this.verifyAtEof();
        }
    }

    private void verify(byte[] buf, int readOffset, int readLen) throws LogVerificationException {
        int endOffset = readOffset + readLen;
        int curOffset = readOffset;
        block8: while (curOffset < endOffset) {
            int remaining = endOffset - curOffset;
            switch (this.state) {
                case INIT: {
                    this.processInit();
                    continue block8;
                }
                case FIXED_HEADER: {
                    curOffset = this.processFixedHeader(buf, curOffset, remaining);
                    continue block8;
                }
                case VARIABLE_HEADER: {
                    curOffset = this.processVariableHeader(buf, curOffset, remaining);
                    continue block8;
                }
                case FILE_HEADER_ITEM: {
                    curOffset = this.processFileHeaderItem(buf, curOffset, remaining);
                    continue block8;
                }
                case ITEM: {
                    curOffset = this.processItem(buf, curOffset, remaining);
                    continue block8;
                }
                case INVALID: {
                    throw this.newVerifyException("May not read after LogVerificationException is thrown");
                }
            }
            assert (false);
        }
    }

    private void verifyAtEof() throws LogVerificationException {
        if (this.state == State.INIT) {
            return;
        }
        if (this.fileNum == this.envImpl.getFileManager().getLastFileNum()) {
            return;
        }
        throw this.newVerifyException("Entry is incomplete");
    }

    private void processInit() {
        this.validator.reset();
        this.headerBuf.clear();
        this.header = null;
        this.itemPosition = 0;
        this.state = State.FIXED_HEADER;
    }

    private int processFixedHeader(byte[] buf, int curOffset, int remaining) throws LogVerificationException {
        assert (this.header == null);
        int maxSize = 14;
        int processSize = Math.min(remaining, 14 - this.headerBuf.position());
        this.headerBuf.put(buf, curOffset, processSize);
        assert (this.headerBuf.position() <= 14);
        if (this.headerBuf.position() == 14) {
            this.headerBuf.flip();
            try {
                this.header = new LogEntryHeader(this.headerBuf, this.logVersion);
            }
            catch (ChecksumException e) {
                throw this.newVerifyException(e);
            }
            if (this.header.getPrevOffset() != this.prevEntryStart) {
                throw this.newVerifyException("Header prevOffset=0x" + Long.toHexString(this.header.getPrevOffset()) + " but prevEntryStart=0x" + Long.toHexString(this.prevEntryStart));
            }
            if (this.header.isInvisible()) {
                LogEntryHeader.turnOffInvisible(this.headerBuf, 0);
            }
            this.validator.update(this.headerBuf.array(), 4, 10);
            if (this.header.isVariableLength()) {
                this.headerBuf.clear();
                this.state = State.VARIABLE_HEADER;
            } else if (this.header.getType() == FILE_HEADER_TYPE_NUM) {
                this.headerBuf.clear();
                this.state = State.FILE_HEADER_ITEM;
            } else {
                this.state = State.ITEM;
            }
        }
        return curOffset + processSize;
    }

    private int processVariableHeader(byte[] buf, int curOffset, int remaining) {
        assert (this.header != null);
        assert (this.header.isVariableLength());
        int maxSize = this.header.getVariablePortionSize();
        int processSize = Math.min(remaining, maxSize - this.headerBuf.position());
        this.headerBuf.put(buf, curOffset, processSize);
        assert (this.headerBuf.position() <= maxSize);
        if (this.headerBuf.position() == maxSize) {
            this.headerBuf.flip();
            this.header.readVariablePortion(this.headerBuf);
            this.validator.update(this.headerBuf.array(), 0, maxSize);
            if (this.header.getType() == FILE_HEADER_TYPE_NUM) {
                this.headerBuf.clear();
                this.state = State.FILE_HEADER_ITEM;
            } else {
                this.state = State.ITEM;
            }
        }
        return curOffset + processSize;
    }

    private int processFileHeaderItem(byte[] buf, int curOffset, int remaining) throws LogVerificationException {
        assert (this.header != null);
        assert (this.logVersion == -1);
        int maxSize = FileHeader.entrySize();
        int processSize = Math.min(remaining, maxSize - this.headerBuf.position());
        this.headerBuf.put(buf, curOffset, processSize);
        assert (this.headerBuf.position() <= maxSize);
        if (this.headerBuf.position() == maxSize) {
            this.validator.update(this.headerBuf.array(), 0, maxSize);
            try {
                this.validator.validate(this.header.getChecksum(), this.fileNum, this.entryStart);
            }
            catch (ChecksumException e) {
                throw this.newVerifyException(e);
            }
            this.headerBuf.flip();
            LogEntry fileHeaderEntry = LogEntryType.LOG_FILE_HEADER.getNewLogEntry();
            fileHeaderEntry.readEntry(this.envImpl, this.header, this.headerBuf);
            FileHeader fileHeaderItem = (FileHeader)fileHeaderEntry.getMainItem();
            this.logVersion = fileHeaderItem.getLogVersion();
            this.prevEntryStart = this.entryStart;
            this.entryStart += (long)(this.header.getSize() + maxSize);
            this.state = State.INIT;
        }
        return curOffset + processSize;
    }

    private int processItem(byte[] buf, int curOffset, int remaining) throws LogVerificationException {
        assert (this.header != null);
        int maxSize = this.header.getItemSize();
        int processSize = Math.min(remaining, maxSize - this.itemPosition);
        this.validator.update(buf, curOffset, processSize);
        this.itemPosition += processSize;
        assert (this.itemPosition <= maxSize);
        if (this.itemPosition == maxSize) {
            try {
                this.validator.validate(this.header.getChecksum(), this.fileNum, this.entryStart);
            }
            catch (ChecksumException e) {
                throw this.newVerifyException(e);
            }
            this.prevEntryStart = this.entryStart;
            this.entryStart += (long)(this.header.getSize() + maxSize);
            this.state = State.INIT;
        }
        return curOffset + processSize;
    }

    private LogVerificationException newVerifyException(String reason) {
        return this.newVerifyException(reason, null);
    }

    private LogVerificationException newVerifyException(Throwable cause) {
        return this.newVerifyException(cause.toString(), cause);
    }

    private LogVerificationException newVerifyException(String reason, Throwable cause) {
        this.state = State.INVALID;
        return new LogVerificationException("Log is invalid, fileName: " + this.fileName + " fileNumber: 0x" + Long.toHexString(this.fileNum) + " logEntryOffset: 0x" + Long.toHexString(this.entryStart) + " verifyState: " + (Object)((Object)this.state) + " reason: " + reason, cause);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        FIXED_HEADER,
        VARIABLE_HEADER,
        ITEM,
        FILE_HEADER_ITEM,
        INVALID;

    }
}

