/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.template.Configuration;
import freemarker.template.Version;
import freemarker.template.utility.DateUtil;

public class CommandLine {
    public static void main(String[] args) {
        Version ver = Configuration.getVersion();
        System.out.println();
        System.out.print("FreeMarker version ");
        System.out.print(ver);
        if (!ver.toString().endsWith("Z") && ver.getBuildDate() != null) {
            System.out.print(" (built on ");
            System.out.print(DateUtil.dateToISO8601String(ver.getBuildDate(), true, true, true, 6, DateUtil.UTC, new DateUtil.TrivialDateToISO8601CalendarFactory()));
            System.out.print(")");
        }
        System.out.println();
        if (ver.isGAECompliant() != null) {
            System.out.print("Google App Engine complian variant: ");
            System.out.println(ver.isGAECompliant() != false ? "Yes" : "No");
        }
        System.out.println();
        System.out.println("Copyright (c) 2003 The Visigoth Software Society.");
        System.out.println("All rights reserved.");
        System.out.println();
        System.out.println("This is Free software. Please read the LICENSE.txt comes with ");
        System.out.println("the distribution for more details.");
        System.out.println();
        System.out.println("For more information and for updates visit our WWW site:");
        System.out.println("http://freemarker.org/");
        System.out.println();
    }
}

