/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.IteratingRuleProvider;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.WebXmlModel;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.WebXmlService;
import org.jboss.windup.rules.apps.xml.DiscoverXmlFilesRuleProvider;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.NamespaceMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.xml.DoctypeUtils;
import org.jboss.windup.util.xml.NamespaceUtils;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverWebXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final String TECH_TAG = "Web XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String dtdRegex = "(?i).*web.application.*";

    public RulePhase getPhase() {
        return RulePhase.DISCOVERY;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverXmlFilesRuleProvider.class});
    }

    public String toStringPerform() {
        return "Discover web.xml files";
    }

    public ConditionBuilder when() {
        return Query.find(XmlFileModel.class).withProperty("rootTagName", (Object)"web-app");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(payload);
        if (doc != null && this.isWebXml(payload, doc)) {
            this.addWebXmlMetadata(event.getGraphContext(), payload, doc);
        }
    }

    private boolean isWebXml(XmlFileModel xml, Document doc) {
        return xml.getDoctype() == null || this.processDoctypeMatches(xml.getDoctype());
    }

    private String getVersion(XmlFileModel xml, Document doc) {
        String version;
        block4: {
            block3: {
                version = null;
                if (xml.getDoctype() == null) break block3;
                if (!this.processDoctypeMatches(xml.getDoctype())) break block4;
                version = this.processDoctypeVersion(xml.getDoctype());
                break block4;
            }
            version = JOOX.$((Document)doc).attr("version");
            if (StringUtils.isBlank((String)version)) {
                String namespace = JOOX.$((Document)doc).find("web-app").namespaceURI();
                if (StringUtils.isBlank((String)namespace)) {
                    namespace = doc.getFirstChild().getNamespaceURI();
                }
                for (NamespaceMetaModel ns : xml.getNamespaces()) {
                    if (!StringUtils.equals((String)ns.getURI(), (String)namespace)) continue;
                    version = NamespaceUtils.extractVersion((String)ns.getSchemaLocation());
                    break;
                }
            }
        }
        return version;
    }

    private void addWebXmlMetadata(GraphContext context, XmlFileModel xml, Document doc) {
        TechnologyTagService technologyTagService = new TechnologyTagService(context);
        technologyTagService.addTagToFileModel((FileModel)xml, TECH_TAG, TECH_TAG_LEVEL);
        WebXmlService webXmlService = new WebXmlService(context);
        String webXmlVersion = this.getVersion(xml, doc);
        WebXmlModel webXml = (WebXmlModel)webXmlService.addTypeToModel((WindupVertexFrame)xml);
        if (StringUtils.isNotBlank((String)webXmlVersion)) {
            webXmlVersion = StringUtils.replace((String)webXmlVersion, (String)"_", (String)".");
            webXml.setSpecificationVersion(webXmlVersion);
        }
        String displayName = JOOX.$((Document)doc).child("display-name").text();
        if (StringUtils.isNotBlank((String)(displayName = StringUtils.trimToNull((String)displayName)))) {
            webXml.setDisplayName(displayName);
        }
        List<EnvironmentReferenceModel> refs = this.processEnvironmentReference(context, doc.getDocumentElement());
        for (EnvironmentReferenceModel ref : refs) {
            webXml.addEnvironmentReference(ref);
        }
    }

    private boolean processDoctypeMatches(DoctypeMetaModel doctypeMetaModel) {
        if (StringUtils.isNotBlank((String)doctypeMetaModel.getPublicId()) && Pattern.matches(dtdRegex, doctypeMetaModel.getPublicId())) {
            return true;
        }
        return StringUtils.isNotBlank((String)doctypeMetaModel.getSystemId()) && Pattern.matches(dtdRegex, doctypeMetaModel.getSystemId());
    }

    private String processDoctypeVersion(DoctypeMetaModel entry) {
        String publicId = entry.getPublicId();
        String systemId = entry.getSystemId();
        String versionInformation = DoctypeUtils.extractVersion((String)publicId, (String)systemId);
        return versionInformation;
    }

    private List<EnvironmentReferenceModel> processEnvironmentReference(GraphContext context, Element element) {
        EnvironmentReferenceService environmentReferenceService = new EnvironmentReferenceService(context);
        ArrayList<EnvironmentReferenceModel> resources = new ArrayList<EnvironmentReferenceModel>();
        List queueReferences = JOOX.$((Element)element).find("resource-ref").get();
        for (Element e : queueReferences) {
            String id = JOOX.$((Element)e).attr("id");
            String type = JOOX.$((Element)e).child("res-type").text();
            String name = JOOX.$((Element)e).child("res-ref-name").text();
            type = StringUtils.trim((String)type);
            EnvironmentReferenceModel ref = environmentReferenceService.findEnvironmentReference(name = StringUtils.trim((String)name), type);
            if (ref == null) {
                ref = (EnvironmentReferenceModel)environmentReferenceService.create();
                ref.setName(name);
                ref.setReferenceType(type);
            }
            ref.setReferenceId(id);
            resources.add(ref);
        }
        return resources;
    }
}

