/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.virtual;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.virtual.TransactionVirtualView;
import org.xadisk.filesystem.virtual.VirtualViewFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VirtualViewDirectory {
    private final HashMap<String, LockedFileInfo> lockedFilesInfo = new HashMap(20);
    private final HashMap<String, LockedFileInfo> lockedDirsInfo = new HashMap(20);
    private final File pointsToPhysicalDirectory;
    private final HashMap<String, VirtualViewFile> virtualViewFiles = new HashMap(20);
    private final TransactionVirtualView owningView;
    private File virtualDirName;
    private final NativeXAFileSystem xaFileSystem;
    private final DurableDiskSession diskSession;

    VirtualViewDirectory(File virtualDirName, File pointsToPhysicalDirectory, TransactionVirtualView owningView, NativeXAFileSystem xaFileSystem, DurableDiskSession diskSession) {
        this.owningView = owningView;
        this.virtualDirName = virtualDirName;
        this.pointsToPhysicalDirectory = pointsToPhysicalDirectory;
        this.xaFileSystem = xaFileSystem;
        this.diskSession = diskSession;
    }

    void createFile(String fileName, boolean isDirectory) throws FileAlreadyExistsException {
        if (this.fileExists(fileName) || this.dirExists(fileName)) {
            throw new FileAlreadyExistsException(fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        if (isDirectory) {
            this.lockedDirsInfo.put(fileName, new LockedFileInfo(null, true));
        } else {
            this.lockedFilesInfo.put(fileName, new LockedFileInfo(null, true));
        }
    }

    void moveDirectoryInto(String dirName, File pointsToPhysicalDir) throws FileAlreadyExistsException {
        if (this.fileExists(dirName) || this.dirExists(dirName)) {
            throw new FileAlreadyExistsException(dirName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.lockedDirsInfo.put(dirName, new LockedFileInfo(pointsToPhysicalDir, true));
    }

    void moveFileInto(String fileName, File pointsToPhysicalFile) throws FileAlreadyExistsException {
        if (this.fileExists(fileName) || this.dirExists(fileName)) {
            throw new FileAlreadyExistsException(fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.lockedFilesInfo.put(fileName, new LockedFileInfo(pointsToPhysicalFile, true));
    }

    void deleteFile(String fileName) throws FileNotExistsException {
        if (!this.fileExists(fileName)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.lockedFilesInfo.put(fileName, new LockedFileInfo(null, false));
    }

    void deleteDir(String fileName) throws FileNotExistsException {
        if (!this.dirExists(fileName)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + fileName);
        }
        if (!this.isWritable()) {
            // empty if block
        }
        this.lockedDirsInfo.put(fileName, new LockedFileInfo(null, false));
    }

    boolean fileExists(String file) {
        LockedFileInfo lockedFileInfo = this.lockedFilesInfo.get(file);
        if (lockedFileInfo != null) {
            return lockedFileInfo.isExisting();
        }
        if (this.pointsToPhysicalDirectory == null) {
            return false;
        }
        return new File(this.pointsToPhysicalDirectory, file).isFile();
    }

    boolean dirExists(String file) {
        LockedFileInfo lockedDirInfo = this.lockedDirsInfo.get(file);
        if (lockedDirInfo != null) {
            return lockedDirInfo.isExisting();
        }
        if (this.pointsToPhysicalDirectory == null) {
            return false;
        }
        return new File(this.pointsToPhysicalDirectory, file).isDirectory();
    }

    boolean isWritable() {
        if (this.pointsToPhysicalDirectory != null) {
            return this.pointsToPhysicalDirectory.canWrite();
        }
        return true;
    }

    private File getPhysicalPath(String name, boolean isDirectory) {
        LockedFileInfo lockedInfo = isDirectory ? this.lockedDirsInfo.get(name) : this.lockedFilesInfo.get(name);
        if (lockedInfo != null) {
            File pointsToPhysical = lockedInfo.getPointsToPhysical();
            return pointsToPhysical;
        }
        if (this.pointsToPhysicalDirectory == null) {
            return null;
        }
        return new File(this.pointsToPhysicalDirectory, name);
    }

    File pointsToPhysicalFile(String file) throws FileNotExistsException {
        if (!this.fileExists(file)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + file);
        }
        return this.getPhysicalPath(file, false);
    }

    File pointsToPhysicalDirectory(String file) throws FileNotExistsException {
        if (!this.dirExists(file)) {
            throw new FileNotExistsException(this.virtualDirName.getAbsolutePath() + File.separator + file);
        }
        return this.getPhysicalPath(file, true);
    }

    private void updateFileDirExistence(Set<String> allFilesDirs, HashMap<String, LockedFileInfo> lockedFilesDirsInfo) {
        for (Map.Entry<String, LockedFileInfo> entry : lockedFilesDirsInfo.entrySet()) {
            LockedFileInfo fileDirInfo = entry.getValue();
            if (fileDirInfo.isExisting()) {
                allFilesDirs.add(entry.getKey());
                continue;
            }
            allFilesDirs.remove(entry.getKey());
        }
    }

    String[] listFilesAndDirectories() {
        HashSet<String> allFilesDirs = new HashSet<String>();
        if (this.pointsToPhysicalDirectory != null) {
            allFilesDirs.addAll(Arrays.asList(this.pointsToPhysicalDirectory.list()));
        }
        this.updateFileDirExistence(allFilesDirs, this.lockedFilesInfo);
        this.updateFileDirExistence(allFilesDirs, this.lockedDirsInfo);
        return allFilesDirs.toArray(new String[0]);
    }

    private boolean isPermissionAvailable(String name, boolean isDirectory, boolean writePermission) {
        LockedFileInfo lockedInfo = isDirectory ? this.lockedDirsInfo.get(name) : this.lockedFilesInfo.get(name);
        if (lockedInfo != null) {
            if (!lockedInfo.isExisting()) {
                return false;
            }
            File pointsToPhysical = lockedInfo.getPointsToPhysical();
            if (pointsToPhysical != null) {
                if (writePermission) {
                    return pointsToPhysical.canWrite();
                }
                return pointsToPhysical.canRead();
            }
            return true;
        }
        if (this.pointsToPhysicalDirectory == null) {
            return false;
        }
        if (writePermission) {
            return new File(this.pointsToPhysicalDirectory, name).canWrite();
        }
        return new File(this.pointsToPhysicalDirectory, name).canRead();
    }

    boolean isFileWritable(String fileName) {
        return this.isPermissionAvailable(fileName, false, true);
    }

    boolean isFileReadable(String fileName) {
        return this.isPermissionAvailable(fileName, false, false);
    }

    boolean isDirWritable(String fileName) {
        return this.isPermissionAvailable(fileName, true, true);
    }

    boolean isDirReadable(String fileName) {
        return this.isPermissionAvailable(fileName, true, false);
    }

    File getPointsToPhysicalDirectory() {
        return this.pointsToPhysicalDirectory;
    }

    private boolean isVirtualFileBeingWritten(String fileName) {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf == null) {
            return false;
        }
        return vvf.isBeingWritten();
    }

    private boolean isVirtualFileBeingRead(String fileName) {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf == null) {
            return false;
        }
        return vvf.isBeingRead();
    }

    boolean isNormalFileBeingReadOrWritten(String fileName) {
        return this.isVirtualFileBeingRead(fileName) || this.isVirtualFileBeingWritten(fileName);
    }

    VirtualViewFile getVirtualViewFile(String fileName) throws FileNotExistsException {
        VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
        if (vvf != null) {
            return vvf;
        }
        File pointingToPhysicalFile = this.pointsToPhysicalFile(fileName);
        File virtualFileName = new File(this.virtualDirName.getAbsolutePath(), fileName);
        if (pointingToPhysicalFile != null) {
            vvf = new VirtualViewFile(virtualFileName, pointingToPhysicalFile.length(), this.owningView, pointingToPhysicalFile, pointingToPhysicalFile.length(), this.xaFileSystem, this.diskSession);
            vvf.setMappedToThePhysicalFileTill(pointingToPhysicalFile.length());
            vvf.setMappedToPhysicalFile(pointingToPhysicalFile);
        } else {
            vvf = new VirtualViewFile(virtualFileName, 0L, this.owningView, this.xaFileSystem, this.diskSession);
            vvf.setMappedToThePhysicalFileTill(-1L);
        }
        this.virtualViewFiles.put(fileName, vvf);
        return vvf;
    }

    VirtualViewFile removeVirtualViewFile(String filename) {
        return this.virtualViewFiles.remove(filename);
    }

    void addVirtualViewFile(String filename, VirtualViewFile vvf) {
        this.virtualViewFiles.put(filename, vvf);
    }

    void propagateMoveCall(File targetPath) {
        this.virtualDirName = targetPath;
        for (String fileName : this.virtualViewFiles.keySet()) {
            VirtualViewFile vvf = this.virtualViewFiles.get(fileName);
            vvf.propagatedAncestorMoveCall(new File(targetPath.getAbsolutePath(), fileName));
        }
    }

    private class LockedFileInfo {
        private File pointsToPhysical;
        private boolean existing;

        public LockedFileInfo(File pointsToPhysical, boolean existing) {
            this.pointsToPhysical = pointsToPhysical;
            this.existing = existing;
        }

        public File getPointsToPhysical() {
            return this.pointsToPhysical;
        }

        public void setPointsToPhysical(File pointsToPhysical) {
            this.pointsToPhysical = pointsToPhysical;
        }

        public boolean isExisting() {
            return this.existing;
        }

        public void setExisting(boolean existing) {
            this.existing = existing;
        }
    }
}

