/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.impl.request;

import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.manager.impl.request.AbstractAddonActionRequest;
import org.jboss.forge.furnace.manager.request.DeployRequest;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;

class DeployRequestImpl
extends AbstractAddonActionRequest
implements DeployRequest {
    DeployRequestImpl(AddonInfo info, MutableAddonRepository repository, Furnace forge) {
        super(info, repository, forge);
    }

    @Override
    public void execute() {
        this.furnace.getLockManager().performLocked(LockMode.WRITE, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DeployRequestImpl.this.deploy(DeployRequestImpl.this.repository);
                DeployRequestImpl.this.repository.enable(DeployRequestImpl.this.addonInfo.getAddon());
                return null;
            }
        });
    }

    protected void deploy(MutableAddonRepository repository) {
        Set addonDependencies;
        AddonId addon = this.addonInfo.getAddon();
        Set resourceJars = this.addonInfo.getResources();
        if (resourceJars.isEmpty()) {
            this.log.fine("No resource JARs found for " + addon);
        }
        if ((addonDependencies = this.addonInfo.getDependencyEntries()).isEmpty()) {
            this.log.fine("No dependencies found for addon " + addon);
        }
        this.log.info("Deploying addon " + addon);
        repository.deploy(addon, (Iterable)addonDependencies, (Iterable)resourceJars);
    }

    @Override
    public String toString() {
        return "Deploy: [" + this.getRequestedAddonInfo() + "]";
    }
}

