/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.utilint.DbLsn;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;

public class ChildReference
implements Loggable {
    private Node target;
    private long lsn;
    private byte[] key;
    private byte state;
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    private static final byte MIGRATE_BIT = 4;
    private static final byte CLEAR_MIGRATE_BIT = -5;
    private static final byte PENDING_DELETED_BIT = 8;

    public ChildReference() {
        this.init(null, Key.EMPTY_KEY, -1L, 0);
    }

    public ChildReference(Node target, byte[] key, long lsn) {
        this.init(target, key, lsn, 2);
    }

    public ChildReference(Node target, byte[] key, long lsn, byte existingState) {
        this.init(target, key, lsn, existingState | 2);
    }

    private void init(Node target, byte[] key, long lsn, int state) {
        this.target = target;
        this.key = key;
        this.lsn = lsn;
        this.state = (byte)state;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.setDirty();
    }

    public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
        if (this.target == null) {
            if (this.lsn == -1L) {
                if (!this.isKnownDeleted()) {
                    throw EnvironmentFailureException.unexpectedState(IN.makeFetchErrorMsg("NULL_LSN without KnownDeleted", in, this.lsn, this.state));
                }
            } else {
                EnvironmentImpl envImpl = database.getDbEnvironment();
                try {
                    Node node = (Node)envImpl.getLogManager().getEntry(this.lsn);
                    node.postFetchInit(database, this.lsn);
                    this.target = node;
                    if (in != null) {
                        in.updateMemorySize(null, this.target);
                    }
                }
                catch (FileNotFoundException e) {
                    if (!this.isKnownDeleted() && !this.isPendingDeleted()) {
                        throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, IN.makeFetchErrorMsg(e.toString(), in, this.lsn, this.state), e);
                    }
                }
                catch (EnvironmentFailureException e) {
                    e.addErrorMessage(IN.makeFetchErrorMsg(null, in, this.lsn, this.state));
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, IN.makeFetchErrorMsg(e.toString(), in, this.lsn, this.state), e);
                }
            }
        }
        return this.target;
    }

    byte getState() {
        return this.state;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public void clearTarget() {
        this.target = null;
    }

    public long getLsn() {
        return this.lsn;
    }

    public void setLsn(long lsn) {
        this.lsn = lsn;
        this.setDirty();
    }

    void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
        if (lsn == -1L && dbImpl.isDeferredWriteMode()) {
            this.setDirty();
        } else {
            this.setLsn(lsn);
        }
    }

    private void setDirty() {
        this.state = (byte)(this.state | 2);
    }

    private boolean isPendingDeleted() {
        return (this.state & 8) != 0;
    }

    public boolean isKnownDeleted() {
        return (this.state & 1) != 0;
    }

    private boolean isDirty() {
        return (this.state & 2) != 0;
    }

    public boolean getMigrate() {
        return (this.state & 4) != 0;
    }

    public void setMigrate(boolean migrate) {
        this.state = migrate ? (byte)(this.state | 4) : (byte)(this.state & 0xFFFFFFFB);
    }

    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key) + LogUtils.getPackedLongLogSize(this.lsn) + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
        LogUtils.writePackedLong(logBuffer, this.lsn);
        logBuffer.put(this.state);
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean unpacked = entryVersion < 6;
        this.key = LogUtils.readByteArray(itemBuffer, unpacked);
        this.lsn = LogUtils.readLong(itemBuffer, unpacked);
        this.state = itemBuffer.get();
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<ref kd=\"").append(this.isKnownDeleted());
        sb.append("\" pd=\"").append(this.isPendingDeleted());
        sb.append("\">");
        sb.append(Key.dumpString(this.key, 0));
        sb.append(DbLsn.toString(this.lsn));
        sb.append("</ref>");
    }

    public long getTransactionId() {
        return 0L;
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String dumpString(int nspaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (this.lsn == -1L) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<lsn/>");
        } else {
            sb.append(DbLsn.dumpString(this.lsn, nspaces));
        }
        sb.append('\n');
        if (this.key == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<key/>");
        } else {
            sb.append(Key.dumpString(this.key, nspaces));
        }
        sb.append('\n');
        if (this.target == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<target/>");
        } else {
            sb.append(this.target.dumpString(nspaces, true));
        }
        sb.append('\n');
        sb.append(TreeUtils.indent(nspaces));
        sb.append("<knownDeleted val=\"");
        sb.append(this.isKnownDeleted()).append("\"/>");
        sb.append("<pendingDeleted val=\"");
        sb.append(this.isPendingDeleted()).append("\"/>");
        sb.append("<dirty val=\"").append(this.isDirty()).append("\"/>");
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, false);
    }
}

