/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveTxnArrayStat
extends Stat<TransactionStats.Active[]> {
    private static final long serialVersionUID = 1L;
    private TransactionStats.Active[] array;

    public ActiveTxnArrayStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    public ActiveTxnArrayStat(StatGroup group, StatDefinition definition, TransactionStats.Active[] array) {
        super(group, definition);
        this.array = array;
    }

    @Override
    public TransactionStats.Active[] get() {
        return this.array;
    }

    @Override
    public void set(TransactionStats.Active[] array) {
        this.array = array;
    }

    @Override
    public void add(Stat<TransactionStats.Active[]> other) {
        throw EnvironmentFailureException.unexpectedState("ActiveTxnArrayStat doesn't support the add operation.");
    }

    @Override
    public void clear() {
        if (this.array != null && this.array.length > 0) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = new TransactionStats.Active(this.array[i].getName(), 0L, 0L);
            }
        }
    }

    public ActiveTxnArrayStat copy() {
        try {
            ActiveTxnArrayStat ret = (ActiveTxnArrayStat)super.clone();
            if (this.array != null && this.array.length > 0) {
                TransactionStats.Active[] newArray = new TransactionStats.Active[this.array.length];
                System.arraycopy(this.array, 0, newArray, 0, this.array.length);
                ret.set(newArray);
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    @Override
    protected String getFormattedValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.array != null && this.array.length > 0) {
            for (TransactionStats.Active active : this.array) {
                sb.append("  txnId = " + Stat.FORMAT.format(active.getId()) + " txnName = " + active.getName() + "\n");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isNotSet() {
        if (this.array == null) {
            return true;
        }
        return this.array.length == 0;
    }
}

