/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.confighandler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.xml.condition.XmlFile;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.xml.NamespaceEntry;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="xmlfile", namespace="http://windup.jboss.org/v1/xml")
public class XmlFileHandler
implements ElementHandler<XmlFile> {
    public XmlFile processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String xpath = JOOX.$((Element)element).attr("matches");
        if (StringUtils.isBlank((String)xpath)) {
            throw new WindupException("Error, 'xmlfile' element must have a non-empty 'matches' attribute");
        }
        String publicId = JOOX.$((Element)element).attr("public-id");
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        List children = JOOX.$((Element)element).children().get();
        for (Element child : children) {
            NamespaceEntry namespaceEntry = (NamespaceEntry)handlerManager.processElement(child);
            namespaceMappings.put(namespaceEntry.getPrefix(), namespaceEntry.getNamespaceURI());
        }
        XmlFile xmlFile = XmlFile.matchesXpath(xpath);
        xmlFile.setPublicId(publicId);
        for (Map.Entry nsMapping : namespaceMappings.entrySet()) {
            xmlFile.namespace((String)nsMapping.getKey(), (String)nsMapping.getValue());
        }
        return xmlFile;
    }
}

