/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.operation.xslt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.ClassLoaders;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphApiCompositeClassLoaderProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.FileReferenceModel;
import org.jboss.windup.reporting.model.LinkModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.model.XsltTransformationModel;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformationOf;
import org.jboss.windup.rules.apps.xml.service.XsltTransformationService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class XSLTTransformation
extends AbstractIterationOperation<XmlFileModel> {
    private ClassLoader contextClassLoader;
    @Inject
    GraphApiCompositeClassLoaderProvider compositeClassLoader;
    private static final Logger LOG = Logging.get(XSLTTransformation.class);
    private String description;
    private String location;
    private String extension;
    private Transformer xsltTransformer;
    private Map<String, String> xsltParameters;

    XSLTTransformation(String variable) {
        super(variable);
    }

    XSLTTransformation() {
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
        this.checkVariableName(event, context);
        WindupVertexFrame payload = this.resolveVariable(event, this.getVariableName());
        if (payload instanceof FileReferenceModel) {
            FileModel file = ((FileReferenceModel)payload).getFile();
            this.perform(event, context, (XmlFileModel)file);
        } else {
            super.perform(event, context);
        }
    }

    public static XSLTTransformationOf of(String variable) {
        return new XSLTTransformationOf(variable);
    }

    public XSLTTransformation withDescription(String description) {
        this.description = description;
        return this;
    }

    public void setSourceLocation(String location) {
        this.location = location;
    }

    public XSLTTransformation withExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public static XSLTTransformation using(String location) {
        return XSLTTransformation.using(location, Thread.currentThread().getContextClassLoader());
    }

    public static XSLTTransformation usingFilesystem(String location) {
        XSLTTransformation tansformation = new XSLTTransformation();
        tansformation.location = location;
        return tansformation;
    }

    public static XSLTTransformation using(String location, ClassLoader classLoader) {
        XSLTTransformation tansformation = new XSLTTransformation();
        tansformation.contextClassLoader = classLoader;
        tansformation.location = location;
        return tansformation;
    }

    private InputStream openInputStream() throws IOException {
        if (this.contextClassLoader != null) {
            return this.contextClassLoader.getResourceAsStream(this.location);
        }
        return new FileInputStream(this.location);
    }

    private void setup() {
        try (InputStream resourceAsStream = this.openInputStream();){
            final StreamSource xsltSource = new StreamSource(resourceAsStream);
            final TransformerFactory tf = TransformerFactory.newInstance();
            tf.setURIResolver(new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    if (StringUtils.contains((String)href, (String)"http://")) {
                        LOG.warning("Trying to fetch remote URL for XSLT.  This is not possible; for speed reasons: " + href + ": " + base);
                        return null;
                    }
                    return new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(href));
                }
            });
            ClassLoaders.executeIn((ClassLoader)TransformerFactory.class.getClassLoader(), (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    XSLTTransformation.this.xsltTransformer = tf.newTransformer(xsltSource);
                    return null;
                }
            });
            if (this.xsltParameters != null) {
                for (String key : this.xsltParameters.keySet()) {
                    LOG.fine("Setting property: " + key + " -> " + this.xsltParameters.get(key));
                    this.xsltTransformer.setParameter(key, this.xsltParameters.get(key));
                }
            }
            LOG.fine("Created XSLT successfully: " + this.location);
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Problem working with xsl file located at " + this.location + ". Please check if the file really exists.", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Not able to initialize the XSLT transformer.", e);
        }
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        this.setup();
        GraphContext graphContext = event.getGraphContext();
        GraphService transformationService = new GraphService(graphContext, XsltTransformationModel.class);
        String fileName = payload.getFileName();
        fileName = StringUtils.replace((String)fileName, (String)".", (String)"-");
        fileName = fileName + this.extension;
        XsltTransformationService xsltTransformationService = new XsltTransformationService(graphContext);
        Path outputPath = xsltTransformationService.getTransformedXSLTPath();
        Path resultPath = outputPath.resolve(fileName);
        DOMSource xmlSource = new DOMSource(payload.asDocument());
        StreamResult xmlResult = new StreamResult(resultPath.toFile());
        try {
            this.xsltTransformer.transform(xmlSource, xmlResult);
            XsltTransformationModel transformation = (XsltTransformationModel)transformationService.create();
            transformation.setDescription(this.description);
            transformation.setExtension(this.extension);
            transformation.setSourceLocation(this.location);
            transformation.setSourceFile(payload);
            transformation.setResult(fileName);
            ClassificationService classificationService = new ClassificationService(graphContext);
            ClassificationModel classificationModel = (ClassificationModel)classificationService.create();
            classificationModel.addFileModel((FileModel)payload);
            GraphService linkService = new GraphService(graphContext, LinkModel.class);
            LinkModel linkModel = (LinkModel)linkService.create();
            linkModel.setDescription(this.description);
            linkModel.setLink("transformedxml/" + fileName);
            classificationModel.addLink(linkModel);
        }
        catch (TransformerException e) {
            LOG.log(Level.SEVERE, "Exception transforming XML.", e);
        }
    }
}

