/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.versions;

import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.EmptyVersionRange;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionRange;

public class SingleVersionRange
implements VersionRange {
    private Version version;

    public SingleVersionRange(Version version) {
        Assert.notNull(version, "Version must not be null.");
        Assert.notNull(version.toString(), "Version must not be null.");
        if (version.toString().isEmpty()) {
            throw new IllegalArgumentException("Version must not be empty.");
        }
        this.version = version;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public Version getMin() {
        return this.version;
    }

    @Override
    public Version getMax() {
        return this.version;
    }

    @Override
    public boolean includes(Version version) {
        return version != null && this.version.equals(version);
    }

    @Override
    public VersionRange getIntersection(VersionRange ... ranges) {
        for (VersionRange range : ranges) {
            if (!range.includes(this.version)) continue;
            return this;
        }
        return new EmptyVersionRange();
    }

    @Override
    public boolean isMaxInclusive() {
        return true;
    }

    @Override
    public boolean isMinInclusive() {
        return true;
    }

    public String toString() {
        return this.version.toString();
    }

    public int hashCode() {
        int result = 13;
        result = this.getMin() == null ? ++result : (result += this.getMin().hashCode());
        result *= this.isMinInclusive() ? 1 : 2;
        result = this.getMax() == null ? (result -= 3) : (result -= this.getMax().hashCode());
        return result *= this.isMaxInclusive() ? 2 : 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionRange)) {
            return false;
        }
        VersionRange restriction = (VersionRange)other;
        if (this.getMin() != null ? !this.getMin().equals(restriction.getMin()) : restriction.getMin() != null) {
            return false;
        }
        if (this.isMinInclusive() != restriction.isMinInclusive()) {
            return false;
        }
        if (this.getMax() != null ? !this.getMax().equals(restriction.getMax()) : restriction.getMax() != null) {
            return false;
        }
        return this.isMaxInclusive() == restriction.isMaxInclusive();
    }
}

