/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.man.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.aesh.util.ANSI;

public class ManParserUtil {
    private static final Pattern boldRegex = Pattern.compile("(\\*[^']+\\*)|('\\S+')|(::$)");

    public static String convertStringToAnsi(String line) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = boldRegex.matcher(line);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                builder.append(line.substring(0, matcher.start(1))).append(ANSI.getBold()).append(line.substring(matcher.start(1) + 1, matcher.end(1) - 1)).append(ANSI.defaultText());
                line = line.substring(matcher.end(1));
                matcher = boldRegex.matcher(line);
                continue;
            }
            if (matcher.group(2) != null) {
                builder.append(line.substring(0, matcher.start(2))).append(ANSI.getUnderline()).append(line.substring(matcher.start(2) + 1, matcher.end(2) - 1)).append(ANSI.defaultText());
                line = line.substring(matcher.end(2));
                matcher = boldRegex.matcher(line);
                continue;
            }
            if (matcher.group(3) == null) continue;
            builder.append(line.substring(0, matcher.start(3)));
            line = line.substring(matcher.end(3));
            matcher = boldRegex.matcher(line);
        }
        if (line.length() > 0) {
            builder.append(line);
        }
        if (builder.length() < 1) {
            return line;
        }
        return builder.toString();
    }
}

