/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.io.File;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.DirectoryResourceImpl;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.FileResourceImpl;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceGenerator;

public class FileResourceGenerator
implements ResourceGenerator<FileResource<?>, File> {
    public boolean handles(Class<?> type, Object resource) {
        return resource instanceof File;
    }

    public <T extends Resource<File>> T getResource(ResourceFactory factory, Class<FileResource<?>> type, File resource) {
        FileOperations fileOperations = factory.getFileOperations();
        if (DirectoryResource.class.isAssignableFrom(type) && (!fileOperations.fileExists(resource) || fileOperations.fileExistsAndIsDirectory(resource)) || fileOperations.fileExistsAndIsDirectory(resource)) {
            return (T)((Object)new DirectoryResourceImpl(factory, resource));
        }
        return (T)((Object)new FileResourceImpl(factory, resource));
    }

    public <T extends Resource<File>> Class<?> getResourceType(ResourceFactory factory, Class<FileResource<?>> type, File resource) {
        FileOperations fileOperations = factory.getFileOperations();
        if (DirectoryResource.class.isAssignableFrom(type) && (!fileOperations.fileExists(resource) || fileOperations.fileExistsAndIsDirectory(resource)) || fileOperations.fileExistsAndIsDirectory(resource)) {
            return DirectoryResource.class;
        }
        return FileResource.class;
    }
}

