/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.comparator.ProjectModelByRootFileComparator;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;

public class SortProjectsByPathMethod
implements WindupFreeMarkerMethod {
    private static final String NAME = "sortProjectsByPathAscending";

    public String getMethodName() {
        return NAME;
    }

    public Object exec(List arguments) throws TemplateModelException {
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (Iterable<ProjectModel>)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        Iterable projectModelIterable = (Iterable)stringModelArg.getWrappedObject();
        ArrayList<ProjectModel> projectModelList = new ArrayList<ProjectModel>();
        for (ProjectModel pm : projectModelIterable) {
            projectModelList.add(pm);
        }
        Collections.sort(projectModelList, new ProjectModelByRootFileComparator());
        ExecutionStatistics.get().end(NAME);
        return projectModelList;
    }

    public void setContext(GraphRewrite event) {
    }
}

