/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;

class WritethroughGraph<T extends Graph>
implements WrapperGraph<T>,
TransactionalGraph {
    private final T graph;

    WritethroughGraph(T graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph expected");
        }
        if (graph instanceof TransactionalGraph) {
            throw new IllegalArgumentException("Can only wrap non-transactional graphs");
        }
        this.graph = graph;
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void rollback() {
        throw new IllegalStateException("Transactions can not be rolled back");
    }

    @Override
    public void commit() {
    }

    @Override
    public Features getFeatures() {
        Features f = this.graph.getFeatures().copyFeatures();
        f.isWrapper = true;
        f.supportsTransactions = true;
        return f;
    }

    @Override
    public Vertex addVertex(Object id) {
        return this.graph.addVertex(id);
    }

    @Override
    public Vertex getVertex(Object id) {
        return this.graph.getVertex(id);
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.graph.removeVertex(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return this.graph.getVertices();
    }

    @Override
    public Iterable<Vertex> getVertices(String key, Object value) {
        return this.graph.getVertices(key, value);
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.graph.addEdge(id, outVertex, inVertex, label);
    }

    @Override
    public Edge getEdge(Object id) {
        return this.graph.getEdge(id);
    }

    @Override
    public void removeEdge(Edge edge) {
        this.graph.removeEdge(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return this.graph.getEdges();
    }

    @Override
    public GraphQuery query() {
        return this.graph.query();
    }

    @Override
    public Iterable<Edge> getEdges(String key, Object value) {
        return this.graph.getEdges(key, value);
    }

    @Override
    public void shutdown() {
        this.graph.shutdown();
    }

    @Override
    public T getBaseGraph() {
        return this.graph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.graph.toString());
    }
}

