/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.xadisk.filesystem.NativeLock;
import org.xadisk.filesystem.TransactionInformation;

public class LockTreeNode {
    private final File path;
    private NativeLock lock;
    private final ConcurrentHashMap<String, LockTreeNode> children = new ConcurrentHashMap();
    private final AtomicReference<TransactionInformation> pinHolder = new AtomicReference<Object>(null);

    LockTreeNode(File path, boolean withExclusiveLock) {
        this.path = path;
        this.lock = new NativeLock(withExclusiveLock, path);
    }

    LockTreeNode getChild(String name) {
        LockTreeNode node = this.children.get(name);
        if (node != null) {
            return node;
        }
        node = new LockTreeNode(new File(this.path, name), false);
        LockTreeNode olderValue = this.children.putIfAbsent(name, node);
        if (olderValue == null) {
            return node;
        }
        return olderValue;
    }

    LockTreeNode[] getAllChildren() {
        return this.children.values().toArray(new LockTreeNode[0]);
    }

    boolean isPinnedByOtherTransaction(TransactionInformation thisTransaction) {
        return this.pinHolder.get() != null && !this.pinHolder.get().equals(thisTransaction);
    }

    boolean attemptPinning(TransactionInformation requestor) {
        TransactionInformation holderTransaction = this.pinHolder.get();
        if (holderTransaction == null) {
            return this.pinHolder.compareAndSet(null, requestor);
        }
        return holderTransaction.equals(requestor);
    }

    void releasePin() {
        this.pinHolder.set(null);
    }

    NativeLock getLock() {
        return this.lock;
    }

    File getPath() {
        return this.path;
    }
}

