/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.bridge.proxies.interfaces.XADiskBasicIOOperations;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.ConcurrencyControl;
import org.xadisk.filesystem.DirectoryModificationEvent;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.SessionCommonness;
import org.xadisk.filesystem.TransactionInformation;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.exceptions.DeadLockVictimizedException;
import org.xadisk.filesystem.exceptions.DirectoryNotEmptyException;
import org.xadisk.filesystem.exceptions.FileAlreadyExistsException;
import org.xadisk.filesystem.exceptions.FileNotExistsException;
import org.xadisk.filesystem.exceptions.FileUnderUseException;
import org.xadisk.filesystem.exceptions.InsufficientPermissionOnFileException;
import org.xadisk.filesystem.exceptions.LockingFailedException;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.exceptions.TransactionFailedException;
import org.xadisk.filesystem.exceptions.TransactionRolledbackException;
import org.xadisk.filesystem.exceptions.TransactionTimeoutException;
import org.xadisk.filesystem.exceptions.XASystemException;
import org.xadisk.filesystem.exceptions.XASystemNoMoreAvailableException;
import org.xadisk.filesystem.exceptions.internal.XASystemIOException;
import org.xadisk.filesystem.pools.PooledBuffer;
import org.xadisk.filesystem.utilities.FileIOUtility;
import org.xadisk.filesystem.utilities.MiscUtils;
import org.xadisk.filesystem.virtual.NativeXAFileInputStream;
import org.xadisk.filesystem.virtual.NativeXAFileOutputStream;
import org.xadisk.filesystem.virtual.TransactionVirtualView;
import org.xadisk.filesystem.virtual.VirtualViewFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSession
implements SessionCommonness {
    private final HashMap<File, Lock> allAcquiredLocks = new HashMap(1000);
    private final ArrayList<NativeXAFileInputStream> allAcquiredInputStreams = new ArrayList(5);
    private final ArrayList<NativeXAFileOutputStream> allAcquiredOutputStreams = new ArrayList(5);
    private final NativeXAFileSystem xaFileSystem;
    private final ConcurrencyControl concurrencyControl;
    private volatile int transactionTimeout = 0;
    private final TransactionInformation xid;
    private boolean rolledbackPrematurely = false;
    private boolean sessionIsUseless = false;
    private volatile boolean startedCommitting = false;
    private Throwable rollbackCause = null;
    private volatile boolean systemHasFailed = false;
    private volatile boolean systemGotShutdown = false;
    private volatile boolean operationsCanContinue = true;
    private volatile Throwable systemFailureCause = null;
    private final TransactionVirtualView view;
    private long fileLockWaitTimeout = 0L;
    private boolean createdForRecovery = false;
    private ArrayList<FileSystemStateChangeEvent> fileStateChangeEventsToRaise = new ArrayList(10);
    private final ArrayList<File> directoriesPinnedInThisSession = new ArrayList(5);
    private final long timeOfEntryToTransaction;
    private final ReentrantLock asynchronousRollbackLock = new ReentrantLock(false);
    private final ArrayList<Long> transactionLogPositions = new ArrayList(25);
    private final ArrayList<Buffer> transactionInMemoryBuffers = new ArrayList(25);
    private boolean publishFileStateChangeEventsOnCommit = false;
    private final HashMap<File, NativeXAFileOutputStream> fileAndOutputStream = new HashMap(1000);
    private boolean usingReadOnlyOptimization = true;
    private final DurableDiskSession diskSession;

    NativeSession(TransactionInformation xid, boolean createdForRecovery, NativeXAFileSystem xaFileSystem) {
        this.xid = xid;
        xid.setOwningSession(this);
        this.xaFileSystem = xaFileSystem;
        this.concurrencyControl = xaFileSystem.getConcurrencyControl();
        this.diskSession = xaFileSystem.createDurableDiskSession();
        this.createdForRecovery = createdForRecovery;
        if (createdForRecovery) {
            this.transactionTimeout = 0;
            this.view = null;
            this.timeOfEntryToTransaction = -100L;
            this.usingReadOnlyOptimization = false;
        } else {
            this.transactionTimeout = xaFileSystem.getDefaultTransactionTimeout();
            this.fileLockWaitTimeout = this.xaFileSystem.getLockTimeOut();
            this.view = new TransactionVirtualView(xid, this, xaFileSystem, this.diskSession);
            this.timeOfEntryToTransaction = System.currentTimeMillis();
            xaFileSystem.assignSessionToTransaction(xid, this);
        }
    }

    public NativeSession(TransactionInformation xid, ArrayList<FileSystemStateChangeEvent> events, NativeXAFileSystem xaFileSystem) {
        this.xid = xid;
        xid.setOwningSession(this);
        this.xaFileSystem = xaFileSystem;
        this.concurrencyControl = xaFileSystem.getConcurrencyControl();
        this.diskSession = xaFileSystem.createDurableDiskSession();
        this.createdForRecovery = true;
        this.usingReadOnlyOptimization = false;
        this.transactionTimeout = 0;
        this.view = null;
        this.timeOfEntryToTransaction = -100L;
        this.fileStateChangeEventsToRaise = events;
        this.publishFileStateChangeEventsOnCommit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAsynchronously(Throwable rollbackCause) {
        try {
            this.asynchronousRollbackLock.lock();
            if (!this.startedCommitting) {
                this.rollbackPrematurely(rollbackCause);
            }
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    void rollbackPrematurely(Throwable rollbackCause) {
        try {
            this.rollback();
            this.rolledbackPrematurely = true;
            this.operationsCanContinue = false;
            this.rollbackCause = rollbackCause;
        }
        catch (TransactionRolledbackException trbe) {
        }
        catch (NoTransactionAssociatedException noTransactionAssociatedException) {
            // empty catch block
        }
    }

    void notifySystemFailure(Throwable systemFailureCause) {
        this.systemHasFailed = true;
        this.operationsCanContinue = false;
        this.systemFailureCause = systemFailureCause;
    }

    void notifySystemShutdown() {
        this.systemGotShutdown = true;
        this.operationsCanContinue = false;
    }

    @Override
    public NativeXAFileInputStream createXAFileInputStream(File f) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        return this.createXAFileInputStream(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NativeXAFileInputStream createXAFileInputStream(File f, boolean lockExclusively) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        NativeXAFileInputStream nativeXAFileInputStream;
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, lockExclusively);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_FILE, f);
            VirtualViewFile vvf = this.view.getVirtualViewFile(f);
            NativeXAFileInputStream temp = new NativeXAFileInputStream(vvf, this, this.xaFileSystem);
            this.allAcquiredInputStreams.add(temp);
            success = true;
            nativeXAFileInputStream = temp;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return nativeXAFileInputStream;
            this.releaseLocks(newLock);
            return nativeXAFileInputStream;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NativeXAFileOutputStream createXAFileOutputStream(File f, boolean heavyWrite) throws FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        NativeXAFileOutputStream nativeXAFileOutputStream;
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, true);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_FILE, f);
            VirtualViewFile vvf = this.view.getVirtualViewFile(f);
            NativeXAFileOutputStream temp = this.getCachedXAFileOutputStream(vvf, this.xid, heavyWrite, this);
            this.allAcquiredOutputStreams.add(temp);
            this.addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType.MODIFIED, f, false);
            success = true;
            this.usingReadOnlyOptimization = false;
            nativeXAFileOutputStream = temp;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return nativeXAFileOutputStream;
            this.releaseLocks(newLock);
            return nativeXAFileOutputStream;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createFile(File f, boolean isDirectory) throws FileAlreadyExistsException, FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, true);
            File parentFile = f.getParentFile();
            this.checkValidParent(f);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_DIRECTORY, parentFile);
            this.view.createFile(f, isDirectory);
            byte operation = isDirectory ? (byte)7 : 6;
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, f.getAbsolutePath(), operation));
            Buffer logEntry = new Buffer(logEntryBytes, this.xaFileSystem);
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(logEntry, this.xid);
            this.addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType.CREATED, f, isDirectory);
            success = true;
            this.usingReadOnlyOptimization = false;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return;
            this.releaseLocks(newLock);
            return;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteFile(File f) throws DirectoryNotEmptyException, FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        boolean isDirectory = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, true);
            File parentFile = f.getParentFile();
            this.checkValidParent(f);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_DIRECTORY, parentFile);
            isDirectory = this.view.deleteFile(f);
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, f.getAbsolutePath(), (byte)5));
            Buffer logEntry = new Buffer(logEntryBytes, this.xaFileSystem);
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(logEntry, this.xid);
            this.addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType.DELETED, f, isDirectory);
            success = true;
            this.usingReadOnlyOptimization = false;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return;
            this.releaseLocks(newLock);
            return;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveFile(File src, File dest) throws FileAlreadyExistsException, FileNotExistsException, FileUnderUseException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        src = src.getAbsoluteFile();
        dest = dest.getAbsoluteFile();
        Lock[] newLocks = new Lock[2];
        boolean success = false;
        boolean isDirectoryMove = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLocks[0] = this.acquireLockIfRequired(src, true);
            newLocks[1] = this.acquireLockIfRequired(dest, true);
            File srcParentFile = src.getParentFile();
            this.checkValidParent(src);
            File destParentFile = dest.getParentFile();
            this.checkValidParent(dest);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_DIRECTORY, srcParentFile);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_DIRECTORY, destParentFile);
            if (this.view.fileExistsAndIsNormal(src)) {
                this.view.moveNormalFile(src, dest);
            } else if (this.view.fileExistsAndIsDirectory(src)) {
                isDirectoryMove = true;
                this.checkAnyOpenStreamToDescendantFiles(src);
                this.concurrencyControl.pinDirectoryForRename(src, this.xid);
                this.directoriesPinnedInThisSession.add(src);
                this.view.moveDirectory(src, dest);
            } else {
                throw new FileNotExistsException(src.getAbsolutePath());
            }
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, src.getAbsolutePath(), dest.getAbsolutePath(), (byte)3));
            Buffer logEntry = new Buffer(logEntryBytes, this.xaFileSystem);
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(logEntry, this.xid);
            this.addToFileSystemEvents(new FileSystemStateChangeEvent.FileSystemEventType[]{FileSystemStateChangeEvent.FileSystemEventType.DELETED, FileSystemStateChangeEvent.FileSystemEventType.CREATED, FileSystemStateChangeEvent.FileSystemEventType.MODIFIED}, new File[]{src, dest, dest}, isDirectoryMove);
            success = true;
            this.usingReadOnlyOptimization = false;
        }
        catch (XASystemException xase) {
            this.xaFileSystem.notifySystemFailure(xase);
            throw xase;
        }
        finally {
            try {
                if (!success) {
                    this.releaseLocks(newLocks);
                    if (isDirectoryMove) {
                        this.concurrencyControl.releaseRenamePinOnDirectory(src);
                    }
                }
            }
            finally {
                this.asynchronousRollbackLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(File src, File dest) throws FileAlreadyExistsException, FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        src = src.getAbsoluteFile();
        dest = dest.getAbsoluteFile();
        Lock[] newLocks = new Lock[2];
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLocks[0] = this.acquireLockIfRequired(src, false);
            newLocks[1] = this.acquireLockIfRequired(dest, true);
            File destParentFile = dest.getParentFile();
            this.checkValidParent(src);
            this.checkValidParent(dest);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_FILE, src);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_DIRECTORY, destParentFile);
            this.view.createFile(dest, false);
            VirtualViewFile srcFileInView = this.view.getVirtualViewFile(src);
            VirtualViewFile destFileInView = this.view.getVirtualViewFile(dest);
            srcFileInView.takeSnapshotInto(destFileInView);
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, src.getAbsolutePath(), dest.getAbsolutePath(), (byte)4));
            Buffer logEntry = new Buffer(logEntryBytes, this.xaFileSystem);
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(logEntry, this.xid);
            this.addToFileSystemEvents(new FileSystemStateChangeEvent.FileSystemEventType[]{FileSystemStateChangeEvent.FileSystemEventType.CREATED, FileSystemStateChangeEvent.FileSystemEventType.MODIFIED}, new File[]{dest, dest}, false);
            success = true;
            this.usingReadOnlyOptimization = false;
        }
        catch (XASystemException xase) {
            this.xaFileSystem.notifySystemFailure(xase);
            throw xase;
        }
        finally {
            try {
                if (!success) {
                    this.releaseLocks(newLocks);
                }
            }
            finally {
                this.asynchronousRollbackLock.unlock();
            }
        }
    }

    @Override
    public boolean fileExists(File f) throws LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        return this.fileExists(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean fileExists(File f, boolean lockExclusively) throws LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        boolean success;
        Lock newLock;
        block24: {
            f = f.getAbsoluteFile();
            newLock = null;
            success = false;
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            if (MiscUtils.isRootPath(f)) break block24;
            File parentDir = f.getParentFile();
            newLock = this.acquireLockIfRequired(f, lockExclusively);
            try {
                this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_DIRECTORY, parentDir);
            }
            catch (FileNotExistsException fnee) {
                boolean bl = false;
                try {
                    if (!success) {
                        this.releaseLocks(newLock);
                    }
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
                return bl;
            }
            success = true;
            boolean bl = this.view.fileExists(f);
            try {
                if (!success) {
                    this.releaseLocks(newLock);
                }
            }
            finally {
                this.asynchronousRollbackLock.unlock();
            }
            return bl;
        }
        boolean parentDir = f.exists();
        try {
            if (!success) {
                this.releaseLocks(newLock);
            }
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
        return parentDir;
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        this.releaseLocks(newLock);
                    }
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean fileExistsAndIsDirectory(File f) throws LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        return this.fileExistsAndIsDirectory(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean fileExistsAndIsDirectory(File f, boolean lockExclusively) throws LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        boolean success;
        Lock newLock;
        block24: {
            f = f.getAbsoluteFile();
            newLock = null;
            success = false;
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            if (MiscUtils.isRootPath(f)) break block24;
            File parentDir = f.getParentFile();
            newLock = this.acquireLockIfRequired(f, lockExclusively);
            try {
                this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_DIRECTORY, parentDir);
            }
            catch (FileNotExistsException fnee) {
                boolean bl = false;
                try {
                    if (!success) {
                        this.releaseLocks(newLock);
                    }
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
                return bl;
            }
            success = true;
            boolean bl = this.view.fileExistsAndIsDirectory(f);
            try {
                if (!success) {
                    this.releaseLocks(newLock);
                }
            }
            finally {
                this.asynchronousRollbackLock.unlock();
            }
            return bl;
        }
        boolean parentDir = f.exists();
        try {
            if (!success) {
                this.releaseLocks(newLock);
            }
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
        return parentDir;
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (!success) {
                        this.releaseLocks(newLock);
                    }
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
                throw throwable;
            }
        }
    }

    @Override
    public String[] listFiles(File f, boolean lockExclusively) throws FileNotExistsException, LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        return this.listFiles(f);
    }

    @Override
    public String[] listFiles(File f) throws FileNotExistsException, LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        f = f.getAbsoluteFile();
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_DIRECTORY, f.getParentFile());
            String[] stringArray = this.view.listFiles(f);
            return stringArray;
        }
        catch (XASystemException xase) {
            this.xaFileSystem.notifySystemFailure(xase);
            throw xase;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    @Override
    public long getFileLength(File f) throws FileNotExistsException, LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        return this.getFileLength(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getFileLength(File f, boolean lockExclusively) throws FileNotExistsException, LockingFailedException, InsufficientPermissionOnFileException, InterruptedException, NoTransactionAssociatedException {
        long l;
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, lockExclusively);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.READ_FILE, f);
            if (!this.view.fileExistsAndIsNormal(f)) {
                throw new FileNotExistsException(f.getAbsolutePath());
            }
            long length = this.view.getVirtualViewFile(f).getLength();
            success = true;
            l = length;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return l;
            this.releaseLocks(newLock);
            return l;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncateFile(File f, long newLength) throws FileNotExistsException, InsufficientPermissionOnFileException, LockingFailedException, InterruptedException, NoTransactionAssociatedException {
        f = f.getAbsoluteFile();
        Lock newLock = null;
        boolean success = false;
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            newLock = this.acquireLockIfRequired(f, true);
            this.checkPermission(XADiskBasicIOOperations.PermissionType.WRITE_FILE, f);
            if (this.view.isNormalFileBeingReadOrWritten(f)) {
                // empty if block
            }
            if (!this.view.fileExistsAndIsNormal(f)) {
                throw new FileNotExistsException(f.getAbsolutePath());
            }
            VirtualViewFile vvf = this.view.getVirtualViewFile(f);
            vvf.truncate(newLength);
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, f.getAbsolutePath(), newLength, (byte)8));
            Buffer logEntry = new Buffer(logEntryBytes, this.xaFileSystem);
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(logEntry, this.xid);
            this.addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType.MODIFIED, f, false);
            success = true;
            this.usingReadOnlyOptimization = false;
        }
        catch (XASystemException xase) {
            try {
                this.xaFileSystem.notifySystemFailure(xase);
                throw xase;
            }
            catch (Throwable throwable) {
                try {
                    if (success) throw throwable;
                    this.releaseLocks(newLock);
                    throw throwable;
                }
                finally {
                    this.asynchronousRollbackLock.unlock();
                }
            }
        }
        try {
            if (success) return;
            this.releaseLocks(newLock);
            return;
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    private void submitPreCommitInformationForLogging() throws NoTransactionAssociatedException, IOException {
        this.releaseAllStreams();
        Iterator<VirtualViewFile> vvfsUpdatedDirectly = this.view.getViewFilesWithLatestViewOnDisk().iterator();
        while (vvfsUpdatedDirectly.hasNext()) {
            vvfsUpdatedDirectly.next().forceAndFreePhysicalChannel();
        }
        HashSet<File> filesOnDisk = this.view.getFilesWithLatestViewOnDisk();
        ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, filesOnDisk));
        this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(new Buffer(logEntryBytes, this.xaFileSystem), this.xid);
        if (this.publishFileStateChangeEventsOnCommit) {
            this.fileStateChangeEventsToRaise = this.xaFileSystem.getFileSystemEventDelegator().retainOnlyInterestingEvents(this.fileStateChangeEventsToRaise);
            logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, this.fileStateChangeEventsToRaise, (byte)10));
            this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(new Buffer(logEntryBytes, this.xaFileSystem), this.xid);
        }
        this.xaFileSystem.getTheGatheringDiskWriter().writeRemainingBuffersNow(this.xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws NoTransactionAssociatedException {
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            this.submitPreCommitInformationForLogging();
            this.xaFileSystem.getTheGatheringDiskWriter().transactionPrepareCompletes(this.xid);
        }
        catch (NoTransactionAssociatedException note) {
            throw note;
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void commit(boolean onePhase) throws NoTransactionAssociatedException {
        block34: {
            block33: {
                logInputStreams = new ArrayList<FileInputStream>();
                this.asynchronousRollbackLock.lock();
                this.checkIfCanContinue();
                if (!onePhase) ** GOTO lbl23
                if (!this.usingReadOnlyOptimization) break block33;
                this.completeReadOnlyTransaction();
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(new Closeable[]{logInputStream});
                }
                this.asynchronousRollbackLock.unlock();
                return;
            }
            try {
                if (!this.createdForRecovery) {
                    this.submitPreCommitInformationForLogging();
                    this.xaFileSystem.getTheGatheringDiskWriter().transactionCommitBegins(this.xid);
                }
                {
                    catch (IOException ioe) {
                        this.xaFileSystem.notifySystemFailure(ioe);
                    }
                }
lbl23:
                // 3 sources

                this.startedCommitting = true;
                logReaderChannels = new HashMap<Integer, FileChannel>(2);
                logReaderChannel = null;
                transactionLogBaseName = this.xaFileSystem.getTransactionLogFileBaseName();
                latestCheckPointForRecoveryCase = 0;
                srcFilesMoved = new HashSet<File>();
                srcFilesCopied = new HashSet<File>();
                if (this.createdForRecovery) {
                    filesDirectlyWrittenToDisk = this.xaFileSystem.getRecoveryWorker().getFilesOnDiskForTransaction(this.xid);
                    logPositions = this.xaFileSystem.getRecoveryWorker().getTransactionLogsPositions(this.xid);
                    latestCheckPointForRecoveryCase = this.xaFileSystem.getRecoveryWorker().getTransactionsLatestCheckPoint(this.xid);
                    latestCheckPointForRecoveryCase = latestCheckPointForRecoveryCase == -1 ? 0 : (latestCheckPointForRecoveryCase += 2);
                } else {
                    filesDirectlyWrittenToDisk = this.view.getFilesWithLatestViewOnDisk();
                    logPositions = this.transactionLogPositions;
                }
                for (i = latestCheckPointForRecoveryCase; i < logPositions.size() - 1; i += 2) {
                    temp = null;
                    logFileIndex = (int)logPositions.get(i).longValue();
                    localPosition = logPositions.get(i + 1);
                    if (logFileIndex == -1) {
                        inMemoryLog = this.transactionInMemoryBuffers.get((int)localPosition);
                        temp = inMemoryLog.getBuffer();
                        temp.position(0);
                        logEntry = TransactionLogEntry.parseLogEntry(temp);
                    } else {
                        if (logReaderChannels.get(logFileIndex) == null) {
                            fis = new FileInputStream(transactionLogBaseName + "_" + logFileIndex);
                            logReaderChannels.put(logFileIndex, fis.getChannel());
                            logInputStreams.add(fis);
                        }
                        logReaderChannel = (FileChannel)logReaderChannels.get(logFileIndex);
                        logReaderChannel.position(localPosition);
                        logEntry = TransactionLogEntry.getNextTransactionLogEntry(logReaderChannel, localPosition, false);
                    }
                    try {
                        if (logEntry.getOperationType() == 2) {
                            f = new File(logEntry.getFileName());
                            if (filesDirectlyWrittenToDisk.contains(f)) continue;
                            this.checkPointDuringModificationAgainstCopy(i - 2, f, srcFilesCopied, srcFilesMoved);
                            this.commitFileAppend(logEntry, temp, logReaderChannel, logFileIndex, localPosition);
                            continue;
                        }
                        if (logEntry.getOperationType() == 5) {
                            fileName = logEntry.getFileName();
                            f = new File(fileName);
                            if (filesDirectlyWrittenToDisk.contains(f)) continue;
                            this.checkPointDuringModificationAgainstCopy(i - 2, f, srcFilesCopied, srcFilesMoved);
                            this.commitDeleteFile(fileName, filesDirectlyWrittenToDisk);
                            continue;
                        }
                        if (logEntry.getOperationType() == 6) {
                            fileName = logEntry.getFileName();
                            f = new File(fileName);
                            if (filesDirectlyWrittenToDisk.contains(f)) continue;
                            this.checkPointDuringCreationAgainstMove(i - 2, f, srcFilesCopied, srcFilesMoved);
                            this.commitCreateFile(fileName);
                            continue;
                        }
                        if (logEntry.getOperationType() == 7) {
                            dirName = logEntry.getFileName();
                            this.checkPointDuringCreationAgainstMove(i - 2, new File(dirName), srcFilesCopied, srcFilesMoved);
                            this.commitCreateDir(dirName);
                            continue;
                        }
                        if (logEntry.getOperationType() == 4) {
                            dest = new File(logEntry.getDestFileName());
                            if (filesDirectlyWrittenToDisk.contains(dest)) continue;
                            this.checkPointDuringCreationAgainstMove(i - 2, dest, srcFilesCopied, srcFilesMoved);
                            this.commitFileCopy(logEntry, srcFilesCopied);
                            continue;
                        }
                        if (logEntry.getOperationType() == 3) {
                            src = new File(logEntry.getFileName());
                            dest = new File(logEntry.getDestFileName());
                            if (filesDirectlyWrittenToDisk.contains(dest)) continue;
                            isDirectoryMove = src.isDirectory();
                            if (isDirectoryMove) {
                                this.declareCheckPoint(i - 2, srcFilesCopied, srcFilesMoved);
                                this.commitMove(logEntry);
                                this.declareCheckPoint(i - 2, srcFilesCopied, srcFilesMoved);
                                continue;
                            }
                            if (!this.checkPointDuringModificationAgainstCopy(i - 2, src, srcFilesCopied, srcFilesMoved)) {
                                this.checkPointDuringCreationAgainstMove(i - 2, dest, srcFilesCopied, srcFilesMoved);
                            }
                            this.commitFileMove(logEntry, srcFilesMoved);
                            continue;
                        }
                        if (logEntry.getOperationType() == 8) {
                            f = new File(logEntry.getFileName());
                            if (filesDirectlyWrittenToDisk.contains(f)) continue;
                            this.checkPointDuringModificationAgainstCopy(i - 2, f, srcFilesCopied, srcFilesMoved);
                            this.commitFileTruncate(logEntry);
                            continue;
                        }
                        if (logEntry.getOperationType() != 9) continue;
                        src = new File(logEntry.getFileName());
                        dest = new File(logEntry.getDestFileName());
                        if (!this.checkPointDuringModificationAgainstCopy(i - 2, src, srcFilesCopied, srcFilesMoved)) {
                            this.checkPointDuringCreationAgainstMove(i - 2, dest, srcFilesCopied, srcFilesMoved);
                        }
                        this.commitFileSpecialMove(logEntry, srcFilesMoved);
                        continue;
                    }
                    catch (XASystemIOException xasioe) {
                        throw (IOException)xasioe.getCause();
                    }
                    catch (IOException ioe) {
                        this.xaFileSystem.notifyTransactionFailure(this.xid);
                        throw new TransactionFailedException(ioe, this.xid);
                    }
                }
                this.diskSession.forceToDisk();
                this.xaFileSystem.getTheGatheringDiskWriter().transactionCompletes(this.xid, true);
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(new Closeable[]{logInputStream});
                }
                logInputStreams.clear();
                this.cleanup();
                this.raiseFileStateChangeEvents();
            }
            catch (IOException ioe) {
                try {
                    this.xaFileSystem.notifySystemFailure(ioe);
                }
                catch (Throwable var21_29) {
                    for (FileInputStream logInputStream : logInputStreams) {
                        MiscUtils.closeAll(new Closeable[]{logInputStream});
                    }
                    this.asynchronousRollbackLock.unlock();
                    throw var21_29;
                }
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(new Closeable[]{logInputStream});
                }
                this.asynchronousRollbackLock.unlock();
                break block34;
            }
            for (FileInputStream logInputStream : logInputStreams) {
                MiscUtils.closeAll(new Closeable[]{logInputStream});
            }
            this.asynchronousRollbackLock.unlock();
        }
    }

    private boolean checkPointDuringModificationAgainstCopy(int currentLogPosition, File fileBeingModified, HashSet<File> srcFilesCopied, HashSet<File> srcFilesMoved) throws IOException {
        if (srcFilesCopied.contains(fileBeingModified)) {
            this.declareCheckPoint(currentLogPosition, srcFilesCopied, srcFilesMoved);
            return true;
        }
        return false;
    }

    private boolean checkPointDuringCreationAgainstMove(int currentLogPosition, File fileBeingCreated, HashSet<File> srcFilesCopied, HashSet<File> srcFilesMoved) throws IOException {
        if (srcFilesMoved.contains(fileBeingCreated)) {
            this.declareCheckPoint(currentLogPosition, srcFilesCopied, srcFilesMoved);
            return true;
        }
        return false;
    }

    private void declareCheckPoint(int currentLogPosition, HashSet<File> srcFilesCopied, HashSet<File> srcFilesMoved) throws IOException {
        this.diskSession.forceToDisk();
        try {
            ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, currentLogPosition));
            this.xaFileSystem.getTheGatheringDiskWriter().forceLog(logEntryBytes);
        }
        catch (IOException ioe) {
            throw new XASystemIOException(ioe);
        }
        srcFilesMoved.clear();
        srcFilesCopied.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeReadOnlyTransaction() throws NoTransactionAssociatedException {
        if (!this.usingReadOnlyOptimization) {
            throw new IllegalStateException("Read-only optimization is not being used.");
        }
        try {
            this.asynchronousRollbackLock.lock();
            this.checkIfCanContinue();
            this.releaseAllStreams();
            this.cleanup();
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeTheTransaction() {
        try {
            this.asynchronousRollbackLock.lock();
            this.cleanup();
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
        finally {
            this.asynchronousRollbackLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitFileAppend(TransactionLogEntry logEntry, ByteBuffer inMemoryLogEntry, FileChannel logReaderChannel, int logFileIndex, long localPosition) throws IOException {
        String fileName = logEntry.getFileName();
        if (!new File(fileName).exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName, true);
            long contentLength = logEntry.getFileContentLength();
            FileChannel fc = fos.getChannel();
            if (logFileIndex == -1) {
                inMemoryLogEntry.position(logEntry.getHeaderLength());
                for (long num = 0L; num < contentLength; num += (long)fc.write(inMemoryLogEntry, logEntry.getFilePosition())) {
                }
            } else {
                logReaderChannel.position(localPosition + (long)logEntry.getHeaderLength());
                if (logEntry.getFilePosition() <= fc.size()) {
                    for (long num = 0L; num < contentLength; num += fc.transferFrom(logReaderChannel, num + logEntry.getFilePosition(), NativeXAFileSystem.maxTransferToChannel(contentLength - num))) {
                    }
                }
            }
            fc.force(false);
        }
        catch (Throwable throwable) {
            MiscUtils.closeAll(fos);
            throw throwable;
        }
        MiscUtils.closeAll(fos);
    }

    private void commitDeleteFile(String fileName, HashSet<File> filesDirectlyWrittenToDisk) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            try {
                this.diskSession.deleteFile(f);
            }
            catch (IOException ioe) {
                if (f.isDirectory() && f.list().length != 0) {
                    for (File file : filesDirectlyWrittenToDisk) {
                        if (!file.getParentFile().equals(f)) continue;
                        return;
                    }
                }
                throw ioe;
            }
        }
    }

    private void commitCreateFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            this.diskSession.deleteFile(f);
        }
        this.diskSession.createFile(f);
    }

    private void commitCreateDir(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            return;
        }
        this.diskSession.createDirectory(f);
    }

    private void commitFileCopy(TransactionLogEntry logEntry, HashSet<File> srcFilesCopied) throws IOException {
        File src = new File(logEntry.getFileName());
        File dest = new File(logEntry.getDestFileName());
        if (dest.exists()) {
            this.diskSession.deleteFile(dest);
            this.diskSession.createFile(dest);
        }
        FileIOUtility.copyFile(src, dest, true);
        srcFilesCopied.add(src);
    }

    private void commitFileMove(TransactionLogEntry logEntry, HashSet<File> srcFilesMoved) throws IOException {
        this.commitMove(logEntry);
        srcFilesMoved.add(new File(logEntry.getFileName()));
    }

    private void commitMove(TransactionLogEntry logEntry) throws IOException {
        File src = new File(logEntry.getFileName());
        File dest = new File(logEntry.getDestFileName());
        if (!src.exists()) {
            return;
        }
        if (dest.isDirectory()) {
            this.diskSession.deleteDirectoryRecursively(dest);
        } else if (dest.exists()) {
            this.diskSession.deleteFile(dest);
        }
        this.diskSession.renameTo(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitFileTruncate(TransactionLogEntry logEntry) throws IOException {
        String fileName = logEntry.getFileName();
        if (!new File(fileName).exists()) {
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName, true);
            FileChannel fc = fos.getChannel();
            fc.truncate(logEntry.getNewLength());
            fc.force(false);
        }
        catch (Throwable throwable) {
            MiscUtils.closeAll(fos);
            throw throwable;
        }
        MiscUtils.closeAll(fos);
    }

    private void commitFileSpecialMove(TransactionLogEntry logEntry, HashSet<File> srcFilesMoved) throws IOException {
        File src = new File(logEntry.getFileName());
        File dest = new File(logEntry.getDestFileName());
        if (!src.exists()) {
            return;
        }
        if (dest.exists()) {
            this.diskSession.deleteFile(dest);
        }
        this.diskSession.renameTo(src, dest);
        srcFilesMoved.add(src);
    }

    private void raiseFileStateChangeEvents() {
        if (this.publishFileStateChangeEventsOnCommit) {
            this.xaFileSystem.getFileSystemEventQueue().addAll(this.fileStateChangeEventsToRaise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws NoTransactionAssociatedException {
        block28: {
            ArrayList<FileInputStream> logInputStreams;
            block27: {
                logInputStreams = new ArrayList<FileInputStream>();
                this.asynchronousRollbackLock.lock();
                this.checkIfCanContinue();
                if (!this.usingReadOnlyOptimization) break block27;
                this.completeReadOnlyTransaction();
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(logInputStream);
                }
                this.asynchronousRollbackLock.unlock();
                return;
            }
            try {
                ArrayList<Long> logPositions;
                this.releaseAllStreams();
                HashMap<Integer, FileChannel> logReaderChannels = new HashMap<Integer, FileChannel>(2);
                FileChannel logReaderChannel = null;
                String transactionLogBaseName = this.xaFileSystem.getTransactionLogFileBaseName();
                if (this.createdForRecovery) {
                    logPositions = this.xaFileSystem.getRecoveryWorker().getTransactionLogsPositions(this.xid);
                } else {
                    HashSet<VirtualViewFile> filesTouchedInPlace = this.view.getViewFilesWithLatestViewOnDisk();
                    for (VirtualViewFile vvf : filesTouchedInPlace) {
                        vvf.freePhysicalChannel();
                    }
                    logPositions = this.transactionLogPositions;
                }
                for (int i = logPositions.size() - 2; i >= 0; i -= 2) {
                    TransactionLogEntry logEntry;
                    ByteBuffer temp = null;
                    int logFileIndex = logPositions.get(i).intValue();
                    long localPosition = logPositions.get(i + 1);
                    if (logFileIndex == -1) {
                        Buffer inMemoryLog = this.transactionInMemoryBuffers.get((int)localPosition);
                        temp = inMemoryLog.getBuffer();
                        temp.position(0);
                        logEntry = TransactionLogEntry.parseLogEntry(temp);
                    } else {
                        if (!logReaderChannels.containsKey(logFileIndex)) {
                            FileInputStream fis = new FileInputStream(transactionLogBaseName + "_" + logFileIndex);
                            logReaderChannels.put(logFileIndex, fis.getChannel());
                            logInputStreams.add(fis);
                        }
                        logReaderChannel = (FileChannel)logReaderChannels.get(logFileIndex);
                        logReaderChannel.position(localPosition);
                        logEntry = TransactionLogEntry.getNextTransactionLogEntry(logReaderChannel, localPosition, false);
                    }
                    FileOutputStream fos = null;
                    try {
                        String fileName;
                        if (logEntry.getOperationType() == 17) {
                            fileName = logEntry.getFileName();
                            fos = new FileOutputStream(fileName, true);
                            long contentLength = logEntry.getFileContentLength();
                            FileChannel fc = fos.getChannel();
                            if (logFileIndex != -1) {
                                logReaderChannel.position(localPosition + (long)logEntry.getHeaderLength());
                                if (logEntry.getFilePosition() <= fc.size()) {
                                    for (long num = 0L; num < contentLength; num += fc.transferFrom(logReaderChannel, num + logEntry.getFilePosition(), NativeXAFileSystem.maxTransferToChannel(contentLength - num))) {
                                    }
                                }
                            }
                            fc.force(false);
                        } else if (logEntry.getOperationType() == 16) {
                            fileName = logEntry.getFileName();
                            fos = new FileOutputStream(fileName, true);
                            FileChannel fc = fos.getChannel();
                            fc.truncate(logEntry.getNewLength());
                            fc.force(false);
                        }
                    }
                    catch (IOException ioe) {
                        try {
                            this.xaFileSystem.notifyTransactionFailure(this.xid);
                            throw new TransactionFailedException(ioe, this.xid);
                        }
                        catch (Throwable throwable) {
                            MiscUtils.closeAll(fos);
                            throw throwable;
                        }
                    }
                    MiscUtils.closeAll(fos);
                }
                this.xaFileSystem.getTheGatheringDiskWriter().transactionCompletes(this.xid, false);
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(logInputStream);
                }
                logInputStreams.clear();
                this.cleanup();
            }
            catch (IOException ioe) {
                try {
                    this.xaFileSystem.notifySystemFailure(ioe);
                }
                catch (Throwable throwable) {
                    for (FileInputStream logInputStream : logInputStreams) {
                        MiscUtils.closeAll(logInputStream);
                    }
                    this.asynchronousRollbackLock.unlock();
                    throw throwable;
                }
                for (FileInputStream logInputStream : logInputStreams) {
                    MiscUtils.closeAll(logInputStream);
                }
                this.asynchronousRollbackLock.unlock();
                break block28;
            }
            for (FileInputStream logInputStream : logInputStreams) {
                MiscUtils.closeAll(logInputStream);
            }
            this.asynchronousRollbackLock.unlock();
        }
    }

    private void cleanup() throws IOException {
        this.sessionIsUseless = true;
        this.operationsCanContinue = false;
        if (this.createdForRecovery) {
            this.xaFileSystem.getRecoveryWorker().cleanupTransactionInfo(this.xid);
        } else {
            this.xaFileSystem.getTheGatheringDiskWriter().cleanupTransactionInfo(this.xid);
        }
        this.releaseAllLocks();
        this.xaFileSystem.removeTransactionSessionEntry(this.xid);
        if (!this.createdForRecovery) {
            Iterator<VirtualViewFile> vvfsInBackupDir = this.view.getViewFilesUsingBackupDir().iterator();
            while (vvfsInBackupDir.hasNext()) {
                vvfsInBackupDir.next().cleanupBackup();
            }
            this.concurrencyControl.releaseRenamePinOnDirectories(this.directoriesPinnedInThisSession);
        }
        for (Buffer buffer : this.transactionInMemoryBuffers) {
            if (!(buffer instanceof PooledBuffer)) continue;
            this.xaFileSystem.getBufferPool().checkIn((PooledBuffer)buffer);
        }
    }

    private void releaseAllLocks() {
        for (Lock lock : this.allAcquiredLocks.values()) {
            this.concurrencyControl.releaseLock(this.xid, lock);
        }
        this.allAcquiredLocks.clear();
    }

    private void releaseAllStreams() throws NoTransactionAssociatedException {
        for (NativeXAFileInputStream xafis : this.allAcquiredInputStreams) {
            xafis.close();
        }
        for (NativeXAFileOutputStream xafos : this.allAcquiredOutputStreams) {
            xafos.close();
            this.deCacheXAFileOutputStream(xafos.getDestinationFile());
        }
    }

    @Override
    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
        return true;
    }

    private void checkPermission(XADiskBasicIOOperations.PermissionType operation, File f) throws FileNotExistsException, InsufficientPermissionOnFileException {
        switch (operation) {
            case READ_FILE: {
                if (!this.view.isNormalFileReadable(f)) break;
                return;
            }
            case WRITE_FILE: {
                if (!this.view.isNormalFileWritable(f)) break;
                return;
            }
            case READ_DIRECTORY: {
                if (!this.view.isDirectoryReadable(f)) break;
                return;
            }
            case WRITE_DIRECTORY: {
                if (!this.view.isDirectoryWritable(f)) break;
                return;
            }
        }
        throw new InsufficientPermissionOnFileException(operation, f.getAbsolutePath());
    }

    private Lock acquireLockIfRequired(File f, boolean exclusive) throws LockingFailedException, InterruptedException, TransactionRolledbackException {
        Lock newLock = null;
        if (!this.alreadyHaveALock(f, exclusive)) {
            try {
                newLock = this.concurrencyControl.acquireFileLock(this.xid, f, this.fileLockWaitTimeout, exclusive);
                if (exclusive) {
                    this.xid.incrementNumOwnedExclusiveLocks();
                }
            }
            catch (DeadLockVictimizedException dlve) {
                this.rollbackPrematurely(dlve);
                throw new TransactionRolledbackException(dlve);
            }
            catch (TransactionTimeoutException tte) {
                this.rollbackPrematurely(tte);
                throw new TransactionRolledbackException(tte);
            }
            this.allAcquiredLocks.put(f, newLock);
        }
        return newLock;
    }

    private boolean alreadyHaveALock(File f, boolean exclusive) {
        Lock existingLock = this.allAcquiredLocks.get(f);
        if (existingLock == null) {
            return false;
        }
        return existingLock.isExclusive() || !exclusive;
    }

    private void checkValidParent(File f) throws FileNotExistsException {
        if (f.getParentFile() == null) {
            throw new FileNotExistsException(f.getParentFile().getAbsolutePath());
        }
    }

    private void releaseLocks(Lock[] locks) {
        for (Lock lock : locks) {
            if (lock == null) continue;
            this.allAcquiredLocks.remove(lock.getResource());
            this.concurrencyControl.releaseLock(this.xid, lock);
        }
    }

    private void releaseLocks(Lock lock) {
        if (lock != null) {
            this.allAcquiredLocks.remove(lock.getResource());
            this.concurrencyControl.releaseLock(this.xid, lock);
        }
    }

    @Override
    public long getFileLockWaitTimeout() {
        return this.fileLockWaitTimeout;
    }

    @Override
    public void setFileLockWaitTimeout(long fileLockWaitTimeout) {
        this.fileLockWaitTimeout = fileLockWaitTimeout;
    }

    public void checkIfCanContinue() throws NoTransactionAssociatedException {
        if (this.operationsCanContinue) {
            return;
        }
        if (this.rolledbackPrematurely) {
            throw new TransactionRolledbackException(this.rollbackCause);
        }
        if (this.sessionIsUseless) {
            throw new NoTransactionAssociatedException();
        }
        if (this.systemHasFailed) {
            throw new XASystemNoMoreAvailableException(this.systemFailureCause);
        }
        if (this.systemGotShutdown) {
            throw new XASystemNoMoreAvailableException();
        }
    }

    public void declareTransactionUsingUndoLogs() throws IOException {
        ByteBuffer logEntryBytes = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, (byte)18));
        this.xaFileSystem.getTheGatheringDiskWriter().forceLog(logEntryBytes);
    }

    public long getTimeOfEntryToTransaction() {
        return this.timeOfEntryToTransaction;
    }

    public ReentrantLock getAsynchronousRollbackLock() {
        return this.asynchronousRollbackLock;
    }

    public void addLogPositionToTransaction(int logFileIndex, long localPosition) {
        this.transactionLogPositions.add(Long.valueOf(logFileIndex));
        this.transactionLogPositions.add(localPosition);
    }

    public void addInMemoryBufferToTransaction(Buffer buffer) {
        this.transactionInMemoryBuffers.add(buffer);
        int indexIntoBufferArray = this.transactionInMemoryBuffers.size() - 1;
        this.addLogPositionToTransaction(-1, indexIntoBufferArray);
    }

    boolean hasStartedCommitting() {
        return this.startedCommitting;
    }

    public TransactionInformation getXid() {
        return this.xid;
    }

    private void checkAnyOpenStreamToDescendantFiles(File ancestor) throws FileUnderUseException {
        for (NativeXAFileInputStream is : this.allAcquiredInputStreams) {
            if (!this.isAncestorOf(ancestor, is.getSourceFileName()) || is.isClosed()) continue;
            throw new FileUnderUseException(is.getSourceFileName().getAbsolutePath(), false);
        }
        for (NativeXAFileOutputStream os : this.allAcquiredOutputStreams) {
            if (!this.isAncestorOf(ancestor, os.getDestinationFile()) || os.isClosed()) continue;
            throw new FileUnderUseException(os.getDestinationFile().getAbsolutePath(), false);
        }
    }

    private boolean isAncestorOf(File a, File b) {
        for (File parentB = b.getParentFile(); parentB != null; parentB = parentB.getParentFile()) {
            if (!a.equals(parentB)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getPublishFileStateChangeEventsOnCommit() {
        return this.publishFileStateChangeEventsOnCommit;
    }

    @Override
    public void setPublishFileStateChangeEventsOnCommit(boolean publishFileStateChangeEventsOnCommit) {
        this.publishFileStateChangeEventsOnCommit = publishFileStateChangeEventsOnCommit;
    }

    private void addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType actionType, File affectedObject, boolean isDirectory) {
        File parentDirectory = null;
        if (actionType.equals((Object)FileSystemStateChangeEvent.FileSystemEventType.CREATED)) {
            this.fileStateChangeEventsToRaise.add(new FileSystemStateChangeEvent(affectedObject, isDirectory, FileSystemStateChangeEvent.FileSystemEventType.CREATED, this.xid));
            parentDirectory = affectedObject.getParentFile();
            if (parentDirectory != null) {
                this.fileStateChangeEventsToRaise.add(new DirectoryModificationEvent(affectedObject, parentDirectory, true, FileSystemStateChangeEvent.FileSystemEventType.MODIFIED, this.xid));
            }
            return;
        }
        if (actionType.equals((Object)FileSystemStateChangeEvent.FileSystemEventType.DELETED)) {
            this.fileStateChangeEventsToRaise.add(new FileSystemStateChangeEvent(affectedObject, isDirectory, FileSystemStateChangeEvent.FileSystemEventType.DELETED, this.xid));
            parentDirectory = affectedObject.getParentFile();
            if (parentDirectory != null) {
                this.fileStateChangeEventsToRaise.add(new DirectoryModificationEvent(affectedObject, parentDirectory, true, FileSystemStateChangeEvent.FileSystemEventType.MODIFIED, this.xid));
            }
            return;
        }
        if (actionType.equals((Object)FileSystemStateChangeEvent.FileSystemEventType.MODIFIED)) {
            this.fileStateChangeEventsToRaise.add(new FileSystemStateChangeEvent(affectedObject, isDirectory, FileSystemStateChangeEvent.FileSystemEventType.MODIFIED, this.xid));
            return;
        }
    }

    private void addToFileSystemEvents(FileSystemStateChangeEvent.FileSystemEventType[] actionType, File[] affectedObject, boolean areDirectories) {
        for (int i = 0; i < actionType.length; ++i) {
            this.addToFileSystemEvents(actionType[i], affectedObject[i], areDirectories);
        }
    }

    @Override
    public void commit() throws NoTransactionAssociatedException {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeXAFileOutputStream getCachedXAFileOutputStream(VirtualViewFile vvf, TransactionInformation xid, boolean heavyWrite, NativeSession owningSession) throws FileUnderUseException {
        HashMap<File, NativeXAFileOutputStream> hashMap = this.fileAndOutputStream;
        synchronized (hashMap) {
            File f = vvf.getFileName();
            NativeXAFileOutputStream xaFOS = this.fileAndOutputStream.get(f);
            if (xaFOS == null || xaFOS.isClosed()) {
                xaFOS = new NativeXAFileOutputStream(vvf, xid, heavyWrite, owningSession, this.xaFileSystem);
                this.fileAndOutputStream.put(f, xaFOS);
            } else if (!vvf.isUsingHeavyWriteOptimization() && heavyWrite) {
                throw new FileUnderUseException(f.getAbsolutePath(), true);
            }
            return xaFOS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deCacheXAFileOutputStream(File f) {
        HashMap<File, NativeXAFileOutputStream> hashMap = this.fileAndOutputStream;
        synchronized (hashMap) {
            this.fileAndOutputStream.remove(f);
        }
    }

    @Override
    public boolean isUsingReadOnlyOptimization() {
        return this.usingReadOnlyOptimization;
    }
}

